package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.bean.common.ReportLogBean;
import com.xdja.jxlsclient.bean.fileupload.FileUploadReportBean;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.JsonUtil;
import com.xdja.jxlsclient.util.SendMsgToRabbitMqUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：SimpClientLoginReportLogHandler
 * @Description：上传文件日志上报处理类
 * @author: wrf
 * @date: 2019/8/19/019 16:48
 * @version: V1.0
 */
public class FileUploadReportLogHandler extends AbstractReportLogHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadReportLogHandler.class);

    @Override
    public void handler(ReportLogBean reportLogBean) throws JxlsClientException {
        try {
            FileUploadReportBean fileUploadReportBean = (FileUploadReportBean)reportLogBean;
            logger.debug("上传文件日志上报>>>ClientLoginReportBean: 【{}】", JsonUtil.toJson(fileUploadReportBean));
            //1、检测参数
            fileUploadReportBean.checkParam();
            //2、封装计算信息
            fileUploadReportBean.initParam();
            //3、发送消息到RabbitMq
            SendMsgToRabbitMqUtil.sendMessage(fileUploadReportBean.getRoutingKey(), JsonUtil.toJson(fileUploadReportBean));
            logger.debug("上传文件日志上报<<<");
        }catch (Exception e) {
            logger.error("上传文件日志上报失败: ", e);
        }
    }

}
