package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.bean.clientlogin.ClientLoginReportBean;
import com.xdja.jxlsclient.bean.common.ReportLogBean;
import com.xdja.jxlsclient.bean.fileupload.FileUploadReportBean;
import com.xdja.jxlsclient.enums.LogTypeEnum;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.init.JxlsClientSystemInit;
import com.xdja.jxlsclient.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @ClassName：ReportLogHandlerFacade
 * @Description：上报日志Handler
 * @author: wrf
 * @date: 2019/8/19/019 16:52
 * @version: V1.0
 */
public class JxlsClientReportLogHandler {
    private static final Logger logger = LoggerFactory.getLogger(JxlsClientReportLogHandler.class);
    /**
     * 日志处理类容器
     */
    private static Map<Integer, AbstractReportLogHandler> mapHandler = new ConcurrentHashMap<Integer, AbstractReportLogHandler>();

    static {
        ClientLoginReportLogHandler clientLoginReportLogHandler = new ClientLoginReportLogHandler();
        mapHandler.put(LogTypeEnum.ClientLoginEnum.CLIENT_LOGIN.getCode(), clientLoginReportLogHandler);
        mapHandler.put(LogTypeEnum.ClientLoginEnum.CLIENT_LOGOUT.getCode(), clientLoginReportLogHandler);
        mapHandler.put(LogTypeEnum.FileUploadEnum.FILE_UPLOAD.getCode(), new FileUploadReportLogHandler());
    }

    /**
     * @Description: 上报【客户端登陆登出】日志
     * @author wrf
     * @Date 2019-08-19 17:11
     * @param clientLoginReportBean 客户端登陆登出日志bean
     * @return
    */
    public static void clientLogin(ClientLoginReportBean clientLoginReportBean) throws JxlsClientException {
        logger.debug("clientLogin上报日志>>>ReportLogBean: 【{}】", JsonUtil.toJson(clientLoginReportBean));
        //3、获取处理类
        handler(clientLoginReportBean);
        logger.debug("clientLogin上报日志<<<");
    }
    /**
     * @Description: 上报【上传文件日志】日志
     * @author wrf
     * @Date 2019-09-02 17:11
     * @param fileUploadReportBean 上传文件日志bean
     * @return
    */
    public static void fileUpload(FileUploadReportBean fileUploadReportBean) throws JxlsClientException {
        logger.debug("fileUpload上报日志>>>FileUploadReportBean: 【{}】", JsonUtil.toJson(fileUploadReportBean));
        //3、获取处理类
        handler(fileUploadReportBean);
        logger.debug("fileUpload上报日志<<<");
    }

    /**
     * @Description: 执行处理
     * @author wrf
     * @Date 2019-09-03 14:13
     * @param reportLogBean 上报日志bean
     * @return
    */
    private static void handler(ReportLogBean reportLogBean) throws JxlsClientException {
        AbstractReportLogHandler abstractReportLogHandler = mapHandler.get(reportLogBean.getLogType());
        if (null == abstractReportLogHandler) {
            logger.error("没有对应的日志上报处理类,请检查日志类型logType的正确性(参见LogTypeEnum类)");
            throw new JxlsClientException("没有对应的日志上报处理类,请检查日志类型logType的正确性(参见LogTypeEnum类)");
        }
        abstractReportLogHandler.handler(reportLogBean);
    }


    public static void main(String[] args) throws JxlsClientException {
        JxlsClientSystemInit.init("simp", "192.168.18.226", 5672, "jxls", "jxls", "192.168.18.204", 6379, null);

        ClientLoginReportBean clientLoginReportBean = new ClientLoginReportBean();

        clientLoginReportBean.setLogType(LogTypeEnum.ClientLoginEnum.CLIENT_LOGIN);
        clientLoginReportBean.setStartTime(System.currentTimeMillis());
        clientLoginReportBean.setEndTime(System.currentTimeMillis() + 1000);
        clientLoginReportBean.setResult(true);

        clientLoginReportBean.setUserId("12322");
        clientLoginReportBean.setClientType("1001");


        JxlsClientReportLogHandler.clientLogin(clientLoginReportBean);

        clientLoginReportBean.setResult(false);
        JxlsClientReportLogHandler.clientLogin(clientLoginReportBean);

        FileUploadReportBean fileUploadReportBean = new FileUploadReportBean();
        fileUploadReportBean.setLogType(LogTypeEnum.FileUploadEnum.FILE_UPLOAD);
        fileUploadReportBean.setStartTime(System.currentTimeMillis());
        fileUploadReportBean.setEndTime(System.currentTimeMillis() + 1000);
        fileUploadReportBean.setResult(true);

        fileUploadReportBean.setFileId("group/00/1333.jpg");
        fileUploadReportBean.setResult(true);

        JxlsClientReportLogHandler.fileUpload(fileUploadReportBean);

    }
}
