package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @ClassName：ReportLogRedisCacheHandler
 * @Description：上传RabbitMq消息缓存
 * @author: wrf
 * @date: 2019/8/20/020 17:12
 * @version: V1.0
 */
public class ReportLogRedisCacheHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReportLogRedisCacheHandler.class);
    private static JedisUtil.Lists lists = JedisUtil.getInstance().new Lists();
    private static JedisUtil.Keys keys = JedisUtil.getInstance().new Keys();

    /**
     * @Description: 缓存上报RabbitMq失败的消息
     * @author wrf
     * @Date 2019-08-21 15:25
     * @param routingKey RabbitMq路由key
     * @param message 上报的消息
     * @return
    */
    public static void cacheMessage(String routingKey, String message) {
        lists.lpush(JedisKeyConst.JXLS_CLIENT_LOG_KEY + routingKey, message);
    }

    private static ExecutorService executorService = null;


    public static void start() {
        //1.关闭线程池
        shutdown();
        //2、新建一个线程池
        executorService = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 1000, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024));

        //消费上报RabbitMq失败的消息
        executorService.submit(new Runnable() {
            @Override
            public void run() {
                SleepTimeCalculateUtil.SleepTimeCalculateBean sleepTimeCalculateBean = SleepTimeCalculateUtil.getSleepTimeCalculateBean();
                while (true) {
                    try {
                        Set<String> setQueue = keys.keys(JedisKeyConst.JXLS_CLIENT_LOG_KEY + "*");
                        logger.debug("消费开始>>>队列：{}", JsonUtil.toJson(setQueue));
                        if (null != setQueue &&  setQueue.size() > 0) {
                            for (String key : setQueue) {
                                long size = lists.llen(key);
                                logger.info("队列名称：【{}】, 队列长度：【{}】消费开始>>>", key, size);
                                if (size > 0) {
                                    for (int i = 0; i < size; i++) {
                                        String msg = lists.rpop(key);
                                        logger.debug("队列名称: 【{}】, Msg: 【{}】", key, msg);
                                        if (CommonUtil.isEmpty(msg)) {
                                            continue;
                                        }

                                        try {
                                            SendMsgToRabbitMqUtil.sendMessage(key.replaceAll(JedisKeyConst.JXLS_CLIENT_LOG_KEY, ""), msg);
                                        } catch (Exception e) {

                                        }
                                    }
                                }
                                logger.info("队列名称：【{}】消费结束, 队列长度：【{}】<<<", key, size);
                            }
                        }
                        logger.debug("消费开始<<<");
                    }catch (Exception e) {
                        logger.error("消费redis缓存的上报RabbitMq的消费线程异常: ", e);
                    }

                    try {
                        SleepTimeCalculateUtil.calculateSleepTime(sleepTimeCalculateBean);

                        Thread.sleep(sleepTimeCalculateBean.getSleepTime() * 1000);
                    } catch (InterruptedException e) {
                        logger.error("ReportLogRedisCacheHandler consumer redis error, sleep {}s consumer.", sleepTimeCalculateBean.getSleepTime());
                        logger.error("消费redis缓存的上报RabbitMq的消费线程休眠异常: ", e);
                    }
                }
            }
        });
    }

    /**
     * @Description: 关闭线程池
     * @author wrf
     * @Date 2019-08-21 15:27
     * @param
     * @return
    */
    public static void shutdown() {
        if (null != executorService) {
            try {
                executorService.shutdown();

                // (所有的任务都结束的时候，返回TRUE)
                if(!executorService.awaitTermination(1, TimeUnit.MINUTES)){
                    // 超时的时候向线程池中所有的线程发出中断(interrupted)。
                    executorService.shutdownNow();
                }
            } catch (InterruptedException e) {
                // awaitTermination方法被中断的时候也中止线程池中全部的线程的执行。
                logger.error("awaitTermination interrupted: " + e);
                executorService.shutdownNow();
            }
        }
    }

}
