package com.xdja.jxlsclient.init;

import com.xdja.jxlsclient.bean.common.Consts;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.CommonUtil;
import com.xdja.jxlsclient.util.JedisPoolConfigConst;
import com.xdja.jxlsclient.util.JedisUtil;
import com.xdja.jxlsclient.util.RabbitMqInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：SystemInit
 * @Description：jxlsclient初始化
 * @author: wrf
 * @date: 2019/8/20/020 11:01
 * @version: V1.0
 */
public class JxlsClientSystemInit {
    private static final Logger logger = LoggerFactory.getLogger(JxlsClientSystemInit.class);

    /**
     * @Description: 初始化
     * @author wrf
     * @Date 2019-08-20 11:03
     * @param systemName 系统名称(systemName属性值，请从枚举类{@link com.xdja.jxlsclient.enums.SystemNameEnum}中获取)
     * @param mqHost rabbitMq 地址
     * @param mqPort rabbitMq 端口
     * @param mqUserName rabbitMq用户名
     * @param mqPassword rabbitMq密码
     * @return
    */
    public static void init(String systemName, String mqHost, int mqPort, String mqUserName, String mqPassword) throws JxlsClientException {
        init(systemName, mqHost + ":" + mqPort, mqUserName, mqPassword);
    }

    /**
     * @Description: 初始化
     * @author wrf
     * @Date 2019-08-20 11:10
     * @param systemName 系统名称
     * @param connectString 连接RabbitMq初始化字符串，例如，192.168.18.204:8080,192.168.24.51:9090
     * @param mqUserName 连接RabbitMq用户名
     * @param mqPassword 连接RabbitMq密码
     * @return
    */
    public static void init(String systemName, String connectString, String mqUserName, String mqPassword) throws JxlsClientException {
        if (CommonUtil.isEmpty(systemName)) {
            logger.error("systemName为空");
            throw new JxlsClientException("systemName不能为空");
        }
        //初始化系统名称
        Consts.systemName = systemName;
        //初始化RabbitMq
        try {
            RabbitMqInit.getInstance().init(connectString, mqUserName, mqPassword);
        }catch (Exception e) {
            logger.error("初始化mq异常", e);
            if (e instanceof RuntimeException) {
                throw new JxlsClientException(e.getMessage());
            }
        }
    }
    /**
     * @Description: 初始化
     * @author wrf
     * @Date 2019-08-20 11:03
     * @param systemName 系统名称
     * @param mqHost rabbitMq 地址
     * @param mqPort rabbitMq 端口
     * @param mqUserName rabbitMq用户名
     * @param mqPassword rabbitMq密码
     * @param redisHost  redis 地址
     * @param redisPort redis 端口
     * @param redisPassword redis密码
     * @return
    */
    public static void init(String systemName, String mqHost, int mqPort, String mqUserName, String mqPassword, String redisHost, int redisPort, String redisPassword) throws JxlsClientException {
        init(systemName, mqHost + ":" + mqPort, mqUserName, mqPassword, redisHost, redisPort, redisPassword);
    }

    /**
     * @Description: 初始化
     * @author wrf
     * @Date 2019-08-20 11:10
     * @param systemName 系统名称
     * @param connectString 连接RabbitMq初始化字符串，例如，192.168.18.204:8080,192.168.24.51:9090
     * @param mqUserName 连接RabbitMq用户名
     * @param mqPassword 连接RabbitMq密码
     * @return
    */
    public static void init(String systemName, String connectString, String mqUserName, String mqPassword, String redisHost, int redisPort, String redisPassword) throws JxlsClientException {
        init(systemName, connectString, mqUserName, mqPassword);

        // 初始化redis
        JedisPoolConfigConst.host = redisHost;
        JedisPoolConfigConst.port = redisPort;
        JedisPoolConfigConst.password = redisPassword;
        JedisUtil.getInstance().init();
    }
}
