package com.xdja.jxlsclient.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;

/**
 * @ClassName：CommonUtil
 * @Description：通用工具类
 * @author: wrf
 * @date: 2019/8/19/019 10:12
 * @version: V1.0
 *
 */
public class CommonUtil {
	
    private static final String IP = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    private static final String IP_DOT = IP + "\\.";
    private static final String CORRECT_IP_REGEX = "^"+ IP_DOT + IP_DOT + IP_DOT +IP+'$';

    /**
     * @Description: ip地址校验
     * @author wrf
     * @Date 2019-08-19 10:12
     * @param host ip地址
     * @return
    */
    public static boolean checkIp(String host){
        if (isEmpty(host)) {
            return false;
        }
        Pattern pattern = Pattern.compile(CORRECT_IP_REGEX);
        return pattern.matcher(host).matches();
    }

    /**
     * @Description: 端口校验
     * @author wrf
     * @Date 2019-08-19 10:14
     * @param port 端口
     * @return
    */
    public static boolean checkPort(int port) {
        if (port < 0 || port > 0xFFFF) {
            return false;
        }
        return true;
    }

   /**
    * @Description: 判断输入的字符串参数是否为空
    * @author wrf
    * @Date 2019-08-19 10:13
    * @param str 输入的字符串
    * @return
   */
    public static boolean isEmpty(String str) {
    	return "null".equalsIgnoreCase(str) || str ==null || str.length() ==0|| 0==str.replaceAll("\\s", "").length();
    }

    /**
     * @Description: 获取本地ip地址
     * @author wrf
     * @Date 2019-05-24 11:12
     * @param
     * @return
     */
    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = (NetworkInterface) allNetInterfaces.nextElement();
                //对网络接口进行筛选,非回送接口 且 非虚拟网卡 且 正在使用中
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) {
                    continue;
                } else {
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (ip != null && ip instanceof Inet4Address) {
                            return ip.getHostAddress();
                        }
                    }
                }
            }
        } catch (Exception e) {

        }
        return "127.0.0.1";
    }
}
