package com.xdja.jxlsclient.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.util.List;
import java.util.Map;

/**
 * @ClassName：FastJsonUtil
 * @Description：基于FastJson 工具类
 * @author: wrf
 * @date: 2019/7/19/019 10:09
 * @version: V1.0
 */
public class JsonUtil {
    private static final SerializeConfig config;

    static {
        config = new SerializeConfig();
        // 使用和json-lib兼容的日期输出格式
        config.put(java.util.Date.class, new JSONLibDataFormatSerializer());
        // 使用和json-lib兼容的日期输出格式
        config.put(java.sql.Date.class, new JSONLibDataFormatSerializer());
    }

    public static final SerializerFeature[] features = {
            // 输出空置字段
//            SerializerFeature.WriteMapNullValue,
            // list字段如果为null，输出为[]，而不是null
            SerializerFeature.WriteNullListAsEmpty
            // 数值字段如果为null，输出为0，而不是null
//            SerializerFeature.WriteNullNumberAsZero,
            // Boolean字段如果为null，输出为false，而不是null
//            SerializerFeature.WriteNullBooleanAsFalse,
            // 字符类型字段如果为null，输出为""，而不是null
//            SerializerFeature.WriteNullStringAsEmpty
    };

    /**
     * @Description: object转换为json字符串
     * @author wrf
     * @Date 2019-07-19 10:16
     * @param object
     * @return
    */
    public static String toJson(Object object) {
        return JSON.toJSONString(object, config, features);
    }

    /**
     * @Description: object 转换为json字符串（）
     * @author wrf
     * @Date 2019-07-19 10:17
     * @param
     * @return
    */
    public static String toJsonNoFeatures(Object object) {
        return JSON.toJSONString(object, config);
    }

    /**
     * @Description: json字符串转换成Object对象
     * @author wrf
     * @Date 2019-07-19 10:17
     * @param text
     * @return
    */
    public static Object toBean(String text) {
        return JSON.parse(text);
    }

    /**
     * @Description: json字符串转换成指定对象
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param text json字符串
     * @param clazz 要转换成的对象
     * @return
    */
    public static <T> T toBean(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz);
    }

    /**
     * @Description: json对象转换成指定对象
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param obj json对象
     * @param clazz 要转换成的对象
     * @return
    */
    public static <T> T toBean(Object obj, Class<T> clazz) {
        return JSON.toJavaObject(toJSONObject(obj), clazz);
    }

    /**
     * @Description: json转换成Object对象数组
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param text json字符串
     * @return
    */
    public static <T> Object[] toArray(String text) {
        return toArray(text, null);
    }

    /**
     * @Description: json转换成指定对象T数组
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param text json字符串
     * @param clazz 指定对象
     * @return
     */
    public static <T> Object[] toArray(String text, Class<T> clazz) {
        return JSON.parseArray(text, clazz).toArray();
    }

    /**
     * @Description: json转换成指定对象T List
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param text json字符串
     * @param clazz 指定对象
     * @return
     */
    public static <T> List<T> toList(String text, Class<T> clazz) {
        return JSON.parseArray(text, clazz);
    }

    /**
     * @Description: json对象转换成指定对象T List
     * @author wrf
     * @Date 2019-07-19 10:18
     * @param obj json字符串
     * @param clazz 指定对象
     * @return
     */
    public static <T> List<T> toList(Object obj, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(obj), clazz);
    }

    /**
     * @Description: 将字符串转化为序列化的json字符串对象
     * @author wrf
     * @Date 2019-07-19 11:06
     * @param text
     * @return
    */
    public static Object textToJson(String text) {
        Object objectJson  = JSON.parse(text);
        return objectJson;
    }

    /**
     * @Description: 转换成JSONObject
     * @author wrf
     * @Date 2019-07-19 11:06
     * @param object
     * @return
    */
    public static JSONObject toJSONObject(Object object) {
        return JSONObject.parseObject(toJson(object));
    }

    /**
     * @Description: 将字符串转化JSONObject
     * @author wrf
     * @Date 2019-07-19 11:06
     * @param text
     * @return
    */
    public static JSONObject toJSONObject(String text) {
        return JSONObject.parseObject(text);
    }

/*   *//**
    * @Description: json字符串转化为map
    * @author wrf
    * @Date 2019-07-19 13:01
    * @param text json字符串
    * @return
   *//*
    public static <K, V> Map<K, V> toMap(String text) {
        Map<K, V> map = (Map<K, V>) JSONObject.parseObject(text);
        return map;
    }*/

   /**
    * @Description: 对象转化为map
    * @author wrf
    * @Date 2019-07-19 13:01
    * @param text json字符串
    * @return
   */
    public static <K, V> Map<K, V> toMapObject(Object text) {
        Map<K, V> map = (Map<K, V>) JSONObject.parseObject(toJson(text));
        return map;
    }

   /**
    * @Description: 对象转化为map
    * @author wrf
    * @Date 2019-07-19 13:01
    * @param text json字符串
    * @return
   */
    public static Map<String, Object> toMap(Object text) {
        return  (Map<String, Object>) JSON.toJSON(text);
    }

   /**
    * @Description: 将map转化为string
    * @author wrf
    * @Date 2019-07-19 13:02
    * @param map
    * @return
   */
    public static <K, V> String toJson(Map<K, V> map) {
        String s = JSONObject.toJSONString(map);
        return s;
    }

   /**
    * @Description: 将map转化为T
    * @author wrf
    * @Date 2019-07-19 13:02
    * @param map
    * @return
   */
    public static <T> T toBean(Map map, Class<T> clazz) {
        return toBean(toJson(map), clazz);
    }

}
