package com.xdja.jxlsclient.util;

/**
 * @Description：休眠时间计算工具类
 * @author: wrf
 * @date: 2018/8/17/017 14:26
 * note:
 */
public class SleepTimeCalculateUtil {

    /**
     * @Description: 计算休眠时间
     *               【如果休眠时间（sleepTime）>= 最大休眠时间（sleepMaxTime），就会一直按照最大休眠时间（sleepMaxTime）休眠】
     * @author wrf
     * @date 2018-08-17 14:53
     * @param sleepTimeCalculateBean
     * @return
    */
    public static void calculateSleepTime(SleepTimeCalculateBean sleepTimeCalculateBean) {
        //最大休眠 30分钟
        int sleepMaxTime = sleepTimeCalculateBean.getSleepMaxTime();
        //每个 时间最大 休眠次数
        int retryMaxNum = sleepTimeCalculateBean.sleepMaxNum;
        //初始化休眠2s
        int sleepTime = sleepTimeCalculateBean.getSleepTime();
        int sleepRate = sleepTimeCalculateBean.getSleepRate();
        int retryNum = sleepTimeCalculateBean.retryNum;

        retryNum ++;
        if (retryNum > retryMaxNum) {
            sleepTime = sleepTime * sleepRate;
            retryNum = 1;
            if (sleepTime > sleepMaxTime) {
                sleepTime = sleepMaxTime;
            }
        }
        sleepTimeCalculateBean.setRetryNum(retryNum);
        sleepTimeCalculateBean.setSleepTime(sleepTime);
    }

    /**
     * @Description: 获取默认的休眠时间Bean（实际休眠时间 = sleepTime * sleepRate）
     * @author wrf
     * @date 2018-08-17 14:54
     * @return SleepTimeCalculateBean
    */
    public static SleepTimeCalculateBean getSleepTimeCalculateBean() {
        return getSleepTimeCalculateBean(SleepTimeCalculateBean.DEFAULT_SLEEP_MAX_TIME, SleepTimeCalculateBean.DEFAULT_RETRY_MAX_NUM,
                SleepTimeCalculateBean.DEFAULT_SLEEP_TIME, SleepTimeCalculateBean.DEFAULT_SLEEP_RATE);
    }

    /**
     * @Description: 获取休眠时间bean（实际休眠时间 = sleepTime * sleepRate）
     * @author wrf
     * @date 2018-08-17 14:55
     * @param sleepMaxTime 最大休眠时间
     * @param sleepMaxNum 每个 时间 最大休眠次数
     * @param sleepTime 休眠时间
     * @param sleepRate 休眠频率
     * @return
    */
    public static SleepTimeCalculateBean getSleepTimeCalculateBean(int sleepMaxTime, int sleepMaxNum, int sleepTime, int sleepRate) {
        return new SleepTimeCalculateBean(sleepMaxTime, sleepMaxNum, sleepTime, sleepRate);
    }

    /**
     * @Description：休眠时间类
     * @author: wrf
     * @date: 2018/8/17/017 14:26
     * note:
     */
    public static class SleepTimeCalculateBean {
        //最大休眠 30分钟
        public static final int DEFAULT_SLEEP_MAX_TIME = 3 * 60;
        //最大休眠次数
        public static final int DEFAULT_RETRY_MAX_NUM = 10;
        //休眠时间
        public static final int DEFAULT_SLEEP_TIME = 2;
        //休眠频率
        public static final int DEFAULT_SLEEP_RATE = 2;

        /**
         * 最大休眠时间
         */
        private int sleepMaxTime;
        /**
         * 每个 时间 最大休眠次数
         */
        private int sleepMaxNum;
        /**
         * 休眠时间
         */
        private int sleepTime;
        /**
         * 休眠频率
         */
        private int sleepRate;
        /**
         * 重试次数
         */
        private int retryNum;

        public SleepTimeCalculateBean() {
            this.sleepMaxTime = DEFAULT_SLEEP_MAX_TIME;
            this.sleepMaxNum = DEFAULT_RETRY_MAX_NUM;
            this.sleepTime = DEFAULT_SLEEP_TIME;
            this.sleepRate = DEFAULT_SLEEP_RATE;
            this.retryNum = 0;
        }

        public SleepTimeCalculateBean(int sleepMaxTime, int sleepMaxNum, int sleepFirstTime, int sleepRate) {
            this.sleepMaxTime = sleepMaxTime > 0 ? sleepMaxTime : DEFAULT_SLEEP_MAX_TIME;
            this.sleepMaxNum = sleepMaxNum > 0 ? sleepMaxNum : DEFAULT_RETRY_MAX_NUM;
            this.sleepTime = sleepFirstTime > 0 ? sleepFirstTime : DEFAULT_SLEEP_TIME;
            this.sleepRate = sleepRate > 0 ? sleepRate : DEFAULT_SLEEP_RATE;
            this.retryNum = 0;
        }

        public int getSleepMaxTime() {
            return sleepMaxTime;
        }

        public void setSleepMaxTime(int sleepMaxTime) {
            this.sleepMaxTime = sleepMaxTime;
        }

        public int getSleepMaxNum() {
            return sleepMaxNum;
        }

        public void setSleepMaxNum(int sleepMaxNum) {
            this.sleepMaxNum = sleepMaxNum;
        }

        public int getSleepTime() {
            return sleepTime;
        }

        public void setSleepTime(int sleepTime) {
            this.sleepTime = sleepTime;
        }

        public int getRetryNum() {
            return retryNum;
        }

        public void setRetryNum(int retryNum) {
            this.retryNum = retryNum;
        }

        public int getSleepRate() {
            return sleepRate;
        }

        public void setSleepRate(int sleepRate) {
            this.sleepRate = sleepRate;
        }
    }
}
