/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.bean.clientlogin.ClientLoginReportBean;
import com.xdja.jxlsclient.bean.common.AbstractReportLogBean;
import com.xdja.jxlsclient.bean.fileupload.FileUploadReportBean;
import com.xdja.jxlsclient.enums.LogTypeEnum;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.handler.AbstractReportLogHandler;
import com.xdja.jxlsclient.handler.ClientLoginReportLogHandler;
import com.xdja.jxlsclient.handler.FileUploadReportLogHandler;
import com.xdja.jxlsclient.init.JxlsClientSystemInit;
import com.xdja.jxlsclient.util.JsonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxlsClientReportLogHandler {
    private static final Logger logger = LoggerFactory.getLogger(JxlsClientReportLogHandler.class);
    private static Map<Integer, AbstractReportLogHandler> mapHandler = new ConcurrentHashMap<Integer, AbstractReportLogHandler>();

    public static void clientLogin(ClientLoginReportBean clientLoginReportBean) throws JxlsClientException {
        logger.debug("clientLogin\u4e0a\u62a5\u65e5\u5fd7>>>AbstractReportLogBean: \u3010{}\u3011", (Object)JsonUtil.toJson(clientLoginReportBean));
        JxlsClientReportLogHandler.handler(clientLoginReportBean);
        logger.debug("clientLogin\u4e0a\u62a5\u65e5\u5fd7<<<");
    }

    public static void fileUpload(FileUploadReportBean fileUploadReportBean) throws JxlsClientException {
        logger.debug("fileUpload\u4e0a\u62a5\u65e5\u5fd7>>>FileUploadReportBean: \u3010{}\u3011", (Object)JsonUtil.toJson(fileUploadReportBean));
        JxlsClientReportLogHandler.handler(fileUploadReportBean);
        logger.debug("fileUpload\u4e0a\u62a5\u65e5\u5fd7<<<");
    }

    private static void handler(AbstractReportLogBean abstractReportLogBean) throws JxlsClientException {
        AbstractReportLogHandler abstractReportLogHandler = mapHandler.get(abstractReportLogBean.getLogType());
        if (null == abstractReportLogHandler) {
            logger.error("\u6ca1\u6709\u5bf9\u5e94\u7684\u65e5\u5fd7\u4e0a\u62a5\u5904\u7406\u7c7b,\u8bf7\u68c0\u67e5\u65e5\u5fd7\u7c7b\u578blogType\u7684\u6b63\u786e\u6027(\u53c2\u89c1LogTypeEnum\u7c7b)");
            throw new JxlsClientException("\u6ca1\u6709\u5bf9\u5e94\u7684\u65e5\u5fd7\u4e0a\u62a5\u5904\u7406\u7c7b,\u8bf7\u68c0\u67e5\u65e5\u5fd7\u7c7b\u578blogType\u7684\u6b63\u786e\u6027(\u53c2\u89c1LogTypeEnum\u7c7b)");
        }
        abstractReportLogHandler.handler(abstractReportLogBean);
    }

    public static void main(String[] args) throws JxlsClientException {
        JxlsClientSystemInit.init("simp", "192.168.9.124", 5672, "jxls", "jxls", "192.168.18.184", 6379, "xdjamanager");
        ClientLoginReportBean clientLoginReportBean = new ClientLoginReportBean();
        clientLoginReportBean.setLogType(LogTypeEnum.ClientLoginEnum.CLIENT_LOGIN);
        clientLoginReportBean.setStartTime(System.currentTimeMillis());
        clientLoginReportBean.setEndTime(System.currentTimeMillis() + 1000L);
        clientLoginReportBean.setResult(true);
        clientLoginReportBean.setUserId("12322");
        clientLoginReportBean.setClientType("1001");
        JxlsClientReportLogHandler.clientLogin(clientLoginReportBean);
        clientLoginReportBean.setResult(false);
        JxlsClientReportLogHandler.clientLogin(clientLoginReportBean);
        FileUploadReportBean fileUploadReportBean = new FileUploadReportBean();
        fileUploadReportBean.setLogType(LogTypeEnum.FileUploadEnum.FILE_UPLOAD);
        fileUploadReportBean.setStartTime(System.currentTimeMillis());
        fileUploadReportBean.setEndTime(System.currentTimeMillis() + 1000L);
        fileUploadReportBean.setResult(true);
        fileUploadReportBean.setFileId("group/00/1333.jpg");
        fileUploadReportBean.setResult(true);
        JxlsClientReportLogHandler.fileUpload(fileUploadReportBean);
    }

    static {
        ClientLoginReportLogHandler clientLoginReportLogHandler = new ClientLoginReportLogHandler();
        mapHandler.put(LogTypeEnum.ClientLoginEnum.CLIENT_LOGIN.getCode(), clientLoginReportLogHandler);
        mapHandler.put(LogTypeEnum.ClientLoginEnum.CLIENT_LOGOUT.getCode(), clientLoginReportLogHandler);
        mapHandler.put(LogTypeEnum.FileUploadEnum.FILE_UPLOAD.getCode(), new FileUploadReportLogHandler());
    }
}

