/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.enums.BizModuleEnum;
import com.xdja.jxlsclient.util.CommonUtil;
import com.xdja.jxlsclient.util.JedisUtil;
import com.xdja.jxlsclient.util.JsonUtil;
import com.xdja.jxlsclient.util.SendMsgToRabbitMqUtil;
import com.xdja.jxlsclient.util.SleepTimeCalculateUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLogRedisCacheHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReportLogRedisCacheHandler.class);
    private static JedisUtil.Lists lists = new JedisUtil.Lists(JedisUtil.getInstance());
    private static Map<String, String> mapRedisQueue = new ConcurrentHashMap<String, String>();
    private static ExecutorService executorService;

    public static void putRedisQueue(String routingKey) {
        mapRedisQueue.put(routingKey, "jxls:client:log:" + routingKey);
    }

    public static void cacheMessage(String routingKey, String message) {
        lists.rpush("jxls:client:log:" + routingKey, message);
    }

    public static void start() {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        ReportLogRedisCacheHandler.shutdown();
        executorService = new ThreadPoolExecutor(1, 8, 1000L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("jxlsclient-pool-" + threadNumber.getAndIncrement());
                return thread;
            }
        });
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                SleepTimeCalculateUtil.SleepTimeCalculateBean sleepTimeCalculateBean = SleepTimeCalculateUtil.getSleepTimeCalculateBean();
                while (true) {
                    Collection setQueue;
                    block11: {
                        setQueue = mapRedisQueue.values();
                        try {
                            logger.debug("\u6d88\u8d39\u5f00\u59cb>>>\u961f\u5217\uff1a{}", (Object)JsonUtil.toJson(setQueue));
                            if (null == setQueue || setQueue.size() <= 0) break block11;
                            for (String redisQueueName : setQueue) {
                                long redisQueueSize = lists.llen(redisQueueName);
                                logger.info("\u961f\u5217\u540d\u79f0\uff1a\u3010{}\u3011, \u961f\u5217\u957f\u5ea6\uff1a\u3010{}\u3011\u6d88\u8d39\u5f00\u59cb>>>", (Object)redisQueueName, (Object)redisQueueSize);
                                if (redisQueueSize > 0L) {
                                    int i = 0;
                                    while ((long)i < redisQueueSize) {
                                        String msg = lists.lpop(redisQueueName);
                                        logger.debug("\u961f\u5217\u540d\u79f0: \u3010{}\u3011, Msg: \u3010{}\u3011", (Object)redisQueueName, (Object)msg);
                                        if (!CommonUtil.isEmpty(msg)) {
                                            try {
                                                SendMsgToRabbitMqUtil.sendMessage(redisQueueName.replaceAll("jxls:client:log:", ""), msg);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                logger.info("\u961f\u5217\u540d\u79f0\uff1a\u3010{}\u3011\u6d88\u8d39\u7ed3\u675f, \u5171\u6d88\u8d39\uff1a\u3010{}\u3011\u6761<<<", (Object)redisQueueName, (Object)redisQueueSize);
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u6d88\u8d39redis\u7f13\u5b58\u7684\u4e0a\u62a5RabbitMq\u7684\u6d88\u8d39\u7ebf\u7a0b\u5f02\u5e38: ", (Throwable)e);
                        }
                    }
                    try {
                        SleepTimeCalculateUtil.calculateSleepTime(sleepTimeCalculateBean);
                        logger.debug("\u6d88\u8d39\u7ed3\u675f,\u4f11\u7720\uff1a\u3010{}\u3011s<<<\u961f\u5217\uff1a{}", (Object)sleepTimeCalculateBean.getSleepTime(), (Object)JsonUtil.toJson(setQueue));
                        Thread.sleep(sleepTimeCalculateBean.getSleepTime() * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error("ReportLogRedisCacheHandler consumer redis error, sleep {}s consumer.", (Object)sleepTimeCalculateBean.getSleepTime());
                        logger.error("\u6d88\u8d39redis\u7f13\u5b58\u7684\u4e0a\u62a5RabbitMq\u7684\u6d88\u8d39\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38: ", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static void shutdown() {
        if (null != executorService) {
            try {
                executorService.shutdown();
                if (!executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                logger.error("awaitTermination interrupted: " + e);
                executorService.shutdownNow();
            }
        }
    }

    static {
        BizModuleEnum[] aryBizModuleEnum = BizModuleEnum.values();
        if (null != aryBizModuleEnum) {
            for (BizModuleEnum bizModuleEnum : aryBizModuleEnum) {
                ReportLogRedisCacheHandler.putRedisQueue(bizModuleEnum.getCode());
            }
        }
        executorService = null;
    }
}

