/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.init;

import com.xdja.jxlsclient.bean.common.Consts;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.CommonUtil;
import com.xdja.jxlsclient.util.JedisPoolConfigConst;
import com.xdja.jxlsclient.util.JedisUtil;
import com.xdja.jxlsclient.util.RabbitMqInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxlsClientSystemInit {
    private static final Logger logger = LoggerFactory.getLogger(JxlsClientSystemInit.class);

    public static void init(String systemName, String mqHost, int mqPort, String mqUserName, String mqPassword) throws JxlsClientException {
        JxlsClientSystemInit.init(systemName, mqHost + ":" + mqPort, mqUserName, mqPassword);
    }

    public static void init(String systemName, String connectString, String mqUserName, String mqPassword) throws JxlsClientException {
        block3: {
            if (CommonUtil.isEmpty(systemName)) {
                logger.error("systemName\u4e3a\u7a7a");
                throw new JxlsClientException("systemName\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Consts.systemName = systemName;
            try {
                RabbitMqInit.getInstance().init(connectString, mqUserName, mqPassword);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316mq\u5f02\u5e38", (Throwable)e);
                if (!(e instanceof RuntimeException)) break block3;
                throw new JxlsClientException(e.getMessage());
            }
        }
    }

    public static void init(String systemName, String mqHost, int mqPort, String mqUserName, String mqPassword, String redisHost, int redisPort, String redisPassword) throws JxlsClientException {
        JxlsClientSystemInit.init(systemName, mqHost + ":" + mqPort, mqUserName, mqPassword, redisHost, redisPort, redisPassword);
    }

    public static void init(String systemName, String connectString, String mqUserName, String mqPassword, String redisHost, int redisPort, String redisPassword) throws JxlsClientException {
        JxlsClientSystemInit.init(systemName, connectString, mqUserName, mqPassword);
        JedisPoolConfigConst.host = redisHost;
        JedisPoolConfigConst.port = redisPort;
        JedisPoolConfigConst.password = redisPassword;
        JedisUtil.getInstance().init();
    }
}

