/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class CommonUtil {
    private static final String IP = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    private static final String IP_DOT = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.";
    private static final String CORRECT_IP_REGEX = "^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$";

    public static boolean checkIp(String host) {
        if (CommonUtil.isEmpty(host)) {
            return false;
        }
        Pattern pattern = Pattern.compile(CORRECT_IP_REGEX);
        return pattern.matcher(host).matches();
    }

    public static boolean checkPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isEmpty(String str) {
        return "null".equalsIgnoreCase(str) || str == null || str.length() == 0 || 0 == str.replaceAll("\\s", "").length();
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "127.0.0.1";
    }
}

