/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.util;

import com.xdja.jxlsclient.bean.common.Consts;
import com.xdja.jxlsclient.handler.ReportLogRedisCacheHandler;
import com.xdja.jxlsclient.util.CommonUtil;
import com.xdja.jxlsclient.util.JedisPoolConfigConst;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.SortingParams;
import redis.clients.util.SafeEncoder;

public class JedisUtil {
    private static final Logger log = LoggerFactory.getLogger(JedisUtil.class);
    private final int expire = 60000;
    public Keys KEYS;
    public Strings STRINGS;
    public Lists LISTS;
    public Sets SETS;
    public Hash HASH;
    public SortSet SORTSET;
    private static JedisPool jedisPool = null;
    private static final JedisUtil jedisUtil = new JedisUtil();

    private JedisUtil() {
    }

    public void init() {
        try {
            if (null == jedisPool && Consts.rabbitMqInit) {
                JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
                jedisPoolConfig.setMaxWaitMillis(3000L);
                jedisPoolConfig.setTestOnBorrow(true);
                jedisPool = CommonUtil.isEmpty(JedisPoolConfigConst.password) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, JedisPoolConfigConst.host, JedisPoolConfigConst.port) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, JedisPoolConfigConst.host, JedisPoolConfigConst.port, 10000, JedisPoolConfigConst.password);
                Consts.switchRedis = true;
                ReportLogRedisCacheHandler.start();
            } else {
                jedisPool.destroy();
                jedisPool = null;
            }
        }
        catch (Exception e) {
            log.error("Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public JedisPool getPool() {
        if (null == jedisPool) {
            this.init();
        }
        return jedisPool;
    }

    public Jedis getJedis() {
        return (Jedis)jedisPool.getResource();
    }

    public static JedisUtil getInstance() {
        return jedisUtil;
    }

    public void returnResource(Jedis jedis) {
        if (null != jedis) {
            jedisPool.returnResource(jedis);
        }
    }

    public void expire(String key, int seconds) {
        if (seconds <= 0) {
            return;
        }
        Jedis jedis = this.getJedis();
        jedis.expire(key, seconds);
        this.returnResource(jedis);
    }

    public void expire(String key) {
        this.expire(key, 60000);
    }

    public static void main(String[] args) {
        JedisUtil jedisUtil = JedisUtil.getInstance();
        Strings strings = jedisUtil.new Strings();
        strings.set("nnn", "nnnn");
        System.out.println("-----" + strings.get("nnn"));
        Jedis jedis = JedisUtil.getInstance().getJedis();
        for (int i = 0; i < 10; ++i) {
            jedis.set("test", "test");
            System.out.println(i + "==" + jedis.get("test"));
        }
        JedisUtil.getInstance().returnResource(jedis);
    }

    public class Scripts {
        public Object evalsha(String script) {
            Jedis jedis = JedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script);
            return obj;
        }

        public Object evalsha(String script, int keyCount, String ... params) {
            Jedis jedis = JedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script, keyCount, params);
            return obj;
        }

        public Object evalsha(String script, List<String> keys, List<String> args) {
            Jedis jedis = JedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script, keys, args);
            return obj;
        }
    }

    public class Lists {
        public long llen(String key) {
            return this.llen(SafeEncoder.encode((String)key));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long llen(byte[] key) {
            Jedis sjedis = null;
            try {
                long count;
                sjedis = JedisUtil.this.getJedis();
                long l = count = sjedis.llen(key).longValue();
                return l;
            }
            finally {
                JedisUtil.this.returnResource(sjedis);
            }
        }

        public String lset(byte[] key, int index, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            String status = jedis.lset(key, (long)index, value);
            JedisUtil.this.returnResource(jedis);
            return status;
        }

        public String lset(String key, int index, String value) {
            return this.lset(SafeEncoder.encode((String)key), index, SafeEncoder.encode((String)value));
        }

        public long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
            return this.linsert(SafeEncoder.encode((String)key), where, SafeEncoder.encode((String)pivot), SafeEncoder.encode((String)value));
        }

        public long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.linsert(key, where, pivot, value);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public String lindex(String key, int index) {
            return SafeEncoder.encode((byte[])this.lindex(SafeEncoder.encode((String)key), index));
        }

        public byte[] lindex(byte[] key, int index) {
            Jedis sjedis = JedisUtil.this.getJedis();
            byte[] value = sjedis.lindex(key, (long)index);
            JedisUtil.this.returnResource(sjedis);
            return value;
        }

        public String lpop(String key) {
            return SafeEncoder.encode((byte[])this.lpop(SafeEncoder.encode((String)key)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] lpop(byte[] key) {
            Jedis jedis = null;
            try {
                byte[] value;
                jedis = JedisUtil.this.getJedis();
                byte[] byArray = value = jedis.lpop(key);
                return byArray;
            }
            finally {
                JedisUtil.this.returnResource(jedis);
            }
        }

        public String blpop(String key) {
            List<String> value = this.blpop(key, "0");
            return value.get(1);
        }

        public List<String> blpop(String ... key) {
            Jedis jedis = JedisUtil.this.getJedis();
            List value = jedis.blpop(key);
            JedisUtil.this.returnResource(jedis);
            return value;
        }

        public List<byte[]> blpop(byte[] ... key) {
            Jedis jedis = JedisUtil.this.getJedis();
            List value = jedis.blpop(key);
            JedisUtil.this.returnResource(jedis);
            return value;
        }

        public String rpop(String key) {
            return SafeEncoder.encode((byte[])this.rpop(SafeEncoder.encode((String)key)));
        }

        public byte[] rpop(byte[] key) {
            Jedis jedis = JedisUtil.this.getJedis();
            byte[] value = jedis.rpop(key);
            JedisUtil.this.returnResource(jedis);
            return value;
        }

        public String brpop(String key) {
            List<String> value = this.brpop(key, "0");
            return value.get(1);
        }

        public List<String> brpop(String ... key) {
            Jedis jedis = JedisUtil.this.getJedis();
            List value = jedis.brpop(key);
            JedisUtil.this.returnResource(jedis);
            return value;
        }

        public List<byte[]> brpop(byte[] ... key) {
            Jedis jedis = JedisUtil.this.getJedis();
            List value = jedis.brpop(key);
            JedisUtil.this.returnResource(jedis);
            return value;
        }

        public long lpush(String key, String value) {
            return this.lpush(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long rpush(String key, String value) {
            Jedis jedis = null;
            try {
                long count;
                jedis = JedisUtil.this.getJedis();
                long l = count = jedis.rpush(key, new String[]{value}).longValue();
                return l;
            }
            finally {
                JedisUtil.this.returnResource(jedis);
            }
        }

        public long rpush(byte[] key, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.rpush(key, (byte[][])new byte[][]{value});
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long lpush(byte[] key, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.lpush(key, (byte[][])new byte[][]{value});
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public List<String> lrange(String key, long start, long end) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.lrange(key, start, end);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public List<byte[]> lrange(byte[] key, int start, int end) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.lrange(key, (long)start, (long)end);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public long lrem(byte[] key, int c, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.lrem(key, (long)c, value);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long lrem(String key, int c, String value) {
            return this.lrem(SafeEncoder.encode((String)key), c, SafeEncoder.encode((String)value));
        }

        public String ltrim(byte[] key, int start, int end) {
            Jedis jedis = JedisUtil.this.getJedis();
            String str = jedis.ltrim(key, (long)start, (long)end);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public String ltrim(String key, int start, int end) {
            return this.ltrim(SafeEncoder.encode((String)key), start, end);
        }
    }

    public class Strings {
        public String get(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            String value = sjedis.get(key);
            JedisUtil.this.returnResource(sjedis);
            return value;
        }

        public byte[] get(byte[] key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            byte[] value = sjedis.get(key);
            JedisUtil.this.returnResource(sjedis);
            return value;
        }

        public String setEx(String key, int seconds, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            String str = jedis.setex(key, seconds, value);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public String setEx(byte[] key, int seconds, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            String str = jedis.setex(key, seconds, value);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public long setnx(String key, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long str = jedis.setnx(key, value);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public String set(String key, String value) {
            return this.set(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
        }

        public String set(String key, byte[] value) {
            return this.set(SafeEncoder.encode((String)key), value);
        }

        public String set(byte[] key, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            String status = jedis.set(key, value);
            JedisUtil.this.returnResource(jedis);
            return status;
        }

        public long setRange(String key, long offset, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long len = jedis.setrange(key, offset, value);
            JedisUtil.this.returnResource(jedis);
            return len;
        }

        public long append(String key, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long len = jedis.append(key, value);
            JedisUtil.this.returnResource(jedis);
            return len;
        }

        public long decrBy(String key, long number) {
            Jedis jedis = JedisUtil.this.getJedis();
            long len = jedis.decrBy(key, number);
            JedisUtil.this.returnResource(jedis);
            return len;
        }

        public long incrBy(String key, long number) {
            Jedis jedis = JedisUtil.this.getJedis();
            long len = jedis.incrBy(key, number);
            JedisUtil.this.returnResource(jedis);
            return len;
        }

        public String getrange(String key, long startOffset, long endOffset) {
            Jedis sjedis = JedisUtil.this.getJedis();
            String value = sjedis.getrange(key, startOffset, endOffset);
            JedisUtil.this.returnResource(sjedis);
            return value;
        }

        public String getSet(String key, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            String str = jedis.getSet(key, value);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public List<String> mget(String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            List str = jedis.mget(keys);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public String mset(String ... keysvalues) {
            Jedis jedis = JedisUtil.this.getJedis();
            String str = jedis.mset(keysvalues);
            JedisUtil.this.returnResource(jedis);
            return str;
        }

        public long strlen(String key) {
            Jedis jedis = JedisUtil.this.getJedis();
            long len = jedis.strlen(key);
            JedisUtil.this.returnResource(jedis);
            return len;
        }
    }

    public class Hash {
        public long hdel(String key, String fieid) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.hdel(key, new String[]{fieid});
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long hdel(String key) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.del(key);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public boolean hexists(String key, String fieid) {
            Jedis sjedis = JedisUtil.this.getJedis();
            boolean s = sjedis.hexists(key, fieid);
            JedisUtil.this.returnResource(sjedis);
            return s;
        }

        public String hget(String key, String fieid) {
            Jedis sjedis = JedisUtil.this.getJedis();
            String s = sjedis.hget(key, fieid);
            JedisUtil.this.returnResource(sjedis);
            return s;
        }

        public byte[] hget(byte[] key, byte[] fieid) {
            Jedis sjedis = JedisUtil.this.getJedis();
            byte[] s = sjedis.hget(key, fieid);
            JedisUtil.this.returnResource(sjedis);
            return s;
        }

        public Map<String, String> hgetAll(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Map map = sjedis.hgetAll(key);
            JedisUtil.this.returnResource(sjedis);
            return map;
        }

        public long hset(String key, String fieid, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.hset(key, fieid, value);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long hset(String key, String fieid, byte[] value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.hset(key.getBytes(), fieid.getBytes(), value);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long hsetnx(String key, String fieid, String value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.hsetnx(key, fieid, value);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public List<String> hvals(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.hvals(key);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public long hincrby(String key, String fieid, long value) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.hincrBy(key, fieid, value);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public Set<String> hkeys(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.hkeys(key);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public long hlen(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long len = sjedis.hlen(key);
            JedisUtil.this.returnResource(sjedis);
            return len;
        }

        public List<String> hmget(String key, String ... fieids) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.hmget(key, fieids);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public List<byte[]> hmget(byte[] key, byte[] ... fieids) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.hmget(key, fieids);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public String hmset(String key, Map<String, String> map) {
            Jedis jedis = JedisUtil.this.getJedis();
            String s = jedis.hmset(key, map);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public String hmset(byte[] key, Map<byte[], byte[]> map) {
            Jedis jedis = JedisUtil.this.getJedis();
            String s = jedis.hmset(key, map);
            JedisUtil.this.returnResource(jedis);
            return s;
        }
    }

    public class SortSet {
        public long zadd(String key, double score, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.zadd(key, score, member);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long zadd(String key, Map<String, Double> scoreMembers) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.zadd(key, scoreMembers);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long zcard(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long len = sjedis.zcard(key);
            JedisUtil.this.returnResource(sjedis);
            return len;
        }

        public long zcount(String key, double min, double max) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long len = sjedis.zcount(key, min, max);
            JedisUtil.this.returnResource(sjedis);
            return len;
        }

        public long zlength(String key) {
            long len = 0L;
            Set<String> set = this.zrange(key, 0, -1);
            len = set.size();
            return len;
        }

        public double zincrby(String key, double score, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            double s = jedis.zincrby(key, score, member);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public Set<String> zrange(String key, int start, int end) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.zrange(key, (long)start, (long)end);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public Set<String> zrangeByScore(String key, double min, double max) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.zrangeByScore(key, min, max);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public long zrank(String key, String member) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long index = sjedis.zrank(key, member);
            JedisUtil.this.returnResource(sjedis);
            return index;
        }

        public long zrevrank(String key, String member) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long index = sjedis.zrevrank(key, member);
            JedisUtil.this.returnResource(sjedis);
            return index;
        }

        public long zrem(String key, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.zrem(key, new String[]{member});
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long zrem(String key) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.del(key);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long zremrangeByRank(String key, int start, int end) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.zremrangeByRank(key, (long)start, (long)end);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long zremrangeByScore(String key, double min, double max) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.zremrangeByScore(key, min, max);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public Set<String> zrevrange(String key, int start, int end) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.zrevrange(key, (long)start, (long)end);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public double zscore(String key, String memeber) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Double score = sjedis.zscore(key, memeber);
            JedisUtil.this.returnResource(sjedis);
            if (score != null) {
                return score;
            }
            return 0.0;
        }
    }

    public class Sets {
        public long sadd(String key, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.sadd(key, new String[]{member});
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long sadd(byte[] key, byte[] member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.sadd(key, (byte[][])new byte[][]{member});
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long scard(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long len = sjedis.scard(key);
            JedisUtil.this.returnResource(sjedis);
            return len;
        }

        public Set<String> sdiff(String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            Set set = jedis.sdiff(keys);
            JedisUtil.this.returnResource(jedis);
            return set;
        }

        public long sdiffstore(String newkey, String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.sdiffstore(newkey, keys);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public Set<String> sinter(String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            Set set = jedis.sinter(keys);
            JedisUtil.this.returnResource(jedis);
            return set;
        }

        public long sinterstore(String newkey, String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.sinterstore(newkey, keys);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public boolean sismember(String key, String member) {
            Jedis sjedis = JedisUtil.this.getJedis();
            boolean s = sjedis.sismember(key, member);
            JedisUtil.this.returnResource(sjedis);
            return s;
        }

        public Set<String> smembers(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.smembers(key);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public Set<byte[]> smembers(byte[] key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            Set set = sjedis.smembers(key);
            JedisUtil.this.returnResource(sjedis);
            return set;
        }

        public long smove(String srckey, String dstkey, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.smove(srckey, dstkey, member);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public String spop(String key) {
            Jedis jedis = JedisUtil.this.getJedis();
            String s = jedis.spop(key);
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public long srem(String key, String member) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.srem(key, new String[]{member});
            JedisUtil.this.returnResource(jedis);
            return s;
        }

        public Set<String> sunion(String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            Set set = jedis.sunion(keys);
            JedisUtil.this.returnResource(jedis);
            return set;
        }

        public long sunionstore(String newkey, String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            long s = jedis.sunionstore(newkey, keys);
            JedisUtil.this.returnResource(jedis);
            return s;
        }
    }

    public class Keys {
        public String flushAll() {
            Jedis jedis = JedisUtil.this.getJedis();
            String stata = jedis.flushAll();
            JedisUtil.this.returnResource(jedis);
            return stata;
        }

        public String rename(String oldkey, String newkey) {
            return this.rename(SafeEncoder.encode((String)oldkey), SafeEncoder.encode((String)newkey));
        }

        public long renamenx(String oldkey, String newkey) {
            Jedis jedis = JedisUtil.this.getJedis();
            long status = jedis.renamenx(oldkey, newkey);
            JedisUtil.this.returnResource(jedis);
            return status;
        }

        public String rename(byte[] oldkey, byte[] newkey) {
            Jedis jedis = JedisUtil.this.getJedis();
            String status = jedis.rename(oldkey, newkey);
            JedisUtil.this.returnResource(jedis);
            return status;
        }

        public long expired(String key, int seconds) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.expire(key, seconds);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long expireAt(String key, long timestamp) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.expireAt(key, timestamp);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long ttl(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            long len = sjedis.ttl(key);
            JedisUtil.this.returnResource(sjedis);
            return len;
        }

        public long persist(String key) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.persist(key);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long del(String ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.del(keys);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public long del(byte[] ... keys) {
            Jedis jedis = JedisUtil.this.getJedis();
            long count = jedis.del(keys);
            JedisUtil.this.returnResource(jedis);
            return count;
        }

        public boolean exists(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            boolean exis = sjedis.exists(key);
            JedisUtil.this.returnResource(sjedis);
            return exis;
        }

        public List<String> sort(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.sort(key);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public List<String> sort(String key, SortingParams parame) {
            Jedis sjedis = JedisUtil.this.getJedis();
            List list = sjedis.sort(key, parame);
            JedisUtil.this.returnResource(sjedis);
            return list;
        }

        public String type(String key) {
            Jedis sjedis = JedisUtil.this.getJedis();
            String type = sjedis.type(key);
            JedisUtil.this.returnResource(sjedis);
            return type;
        }

        public Set<String> keys(String pattern) {
            Jedis jedis = JedisUtil.this.getJedis();
            Set set = jedis.keys(pattern);
            JedisUtil.this.returnResource(jedis);
            return set;
        }
    }
}

