/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final SerializeConfig config = new SerializeConfig();
    public static final SerializerFeature[] features;

    public static String toJson(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJsonNoFeatures(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object toBean(String text) {
        return JSON.parse((String)text);
    }

    public static <T> T toBean(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> T toBean(Object obj, Class<T> clazz) {
        return (T)JSON.toJavaObject((JSON)JsonUtil.toJSONObject(obj), clazz);
    }

    public static <T> Object[] toArray(String text) {
        return JsonUtil.toArray(text, null);
    }

    public static <T> Object[] toArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz).toArray();
    }

    public static <T> List<T> toList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static <T> List<T> toList(Object obj, Class<T> clazz) {
        return JSON.parseArray((String)JSON.toJSONString((Object)obj), clazz);
    }

    public static Object textToJson(String text) {
        Object objectJson = JSON.parse((String)text);
        return objectJson;
    }

    public static JSONObject toJSONObject(Object object) {
        return JSONObject.parseObject((String)JsonUtil.toJson(object));
    }

    public static JSONObject toJSONObject(String text) {
        return JSONObject.parseObject((String)text);
    }

    public static <K, V> Map<K, V> toMapObject(Object text) {
        JSONObject map = JSONObject.parseObject((String)JsonUtil.toJson(text));
        return map;
    }

    public static Map<String, Object> toMap(Object text) {
        return (Map)JSON.toJSON((Object)text);
    }

    public static <K, V> String toJson(Map<K, V> map) {
        String s = JSONObject.toJSONString(map);
        return s;
    }

    public static <T> T toBean(Map map, Class<T> clazz) {
        return JsonUtil.toBean(JsonUtil.toJson(map), clazz);
    }

    static {
        config.put(Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        config.put(java.sql.Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        features = new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty};
    }
}

