/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.util;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.xdja.jxlsclient.bean.common.Consts;
import com.xdja.jxlsclient.util.CommonUtil;
import com.xdja.jxlsclient.util.SleepTimeCalculateUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqInit {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqInit.class);
    private static AutorecoveringConnection connection = null;
    private static Channel channel = null;

    private RabbitMqInit() {
    }

    public static RabbitMqInit getInstance() {
        return RabbitMqInitHolder.instance;
    }

    public synchronized void init(String host, int port, String mqUserName, String mqPassword) throws Exception {
        logger.info("RabbitMq\u521d\u59cb\u5316>>>host:\u3010{}\u3011, port:\u3010{}\u3011, mqUserName:\u3010{}\u3011, mqPassword:\u3010{}\u3011", new Object[]{host, port, mqUserName, mqPassword});
        this.init(host + ":" + port, mqUserName, mqPassword);
        logger.info("RabbitMq\u521d\u59cb\u5316<<<");
    }

    public synchronized void init(String connectString, final String mqUserName, final String mqPassword) throws Exception {
        String[] aryIpPort;
        Consts.rabbitMqInit = true;
        logger.info("RabbitMq\u521d\u59cb\u5316>>>connectString:\u3010{}\u3011, mqUserName:\u3010{}\u3011, mqPassword:\u3010{}\u3011", new Object[]{connectString, mqUserName, mqPassword});
        if (null != connection) {
            logger.info("rabbitMq\u5df2\u8fde\u63a5");
            if (null != channel) {
                channel.close();
            }
            connection.close();
        }
        if (null == (aryIpPort = connectString.split(",")) || aryIpPort.length < 1) {
            logger.error("rabbitMq\u8fde\u63a5\u5730\u5740\u914d\u7f6e\u6709\u8bef");
            throw new RuntimeException("rabbitMq\u8fde\u63a5\u5730\u5740\u914d\u7f6e\u6709\u8bef,connectString\u6807\u51c6\u683c\u5f0f\u4e3aip:port\u591a\u4e2aip\u548cport\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\uff0c\u4f8b\u5982\uff1a192.168.18.204:8080,192.168.88.204:8082");
        }
        final ArrayList<Address> listAddress = new ArrayList<Address>();
        for (String ipPort : aryIpPort) {
            List<Address> aryAddress;
            String[] aryIp = ipPort.split(":");
            if (null == aryIp || aryIp.length != 2 || null == (aryAddress = this.buildMqAddress(aryIp[0], Integer.parseInt(aryIp[1]))) || aryAddress.size() <= 0) continue;
            listAddress.addAll(aryAddress);
        }
        if (null == listAddress || listAddress.size() < 1) {
            logger.error("\u8fde\u63a5mq\u5730\u5740\u4e0d\u6b63\u786e");
        }
        if (null != connection && connection.isOpen()) {
            Thread.sleep(2000L);
        }
        try {
            connection = this.newConnection(listAddress.toArray(new Address[0]), mqUserName, mqPassword);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u8fde\u63a5RabbitMq\u5931\u8d25\uff0c\u542f\u52a8\u5f02\u6b65\u7ebf\u7a0b\u5b9a\u65f6\u8fde\u63a5RabbitMq");
        }
        if (null == connection) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    connection = RabbitMqInit.this.getMqConnection(listAddress.toArray(new Address[0]), mqUserName, mqPassword);
                }
            }).start();
        } else {
            Consts.rabbitMqConnnectionSuccess = true;
        }
    }

    private List<Address> buildMqAddress(String host, int port) {
        boolean checkIp = CommonUtil.checkIp(host);
        if (!checkIp) {
            return null;
        }
        boolean checkPort = CommonUtil.checkPort(port);
        if (!checkPort) {
            return null;
        }
        ArrayList<Address> listAddress = new ArrayList<Address>();
        Address address = new Address(host, port);
        listAddress.add(address);
        return listAddress;
    }

    private AutorecoveringConnection newConnection(Address[] addresses, String mqUserName, String mqPassword) throws Exception {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(mqUserName);
        factory.setPassword(mqPassword);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(5000);
        connection = (AutorecoveringConnection)factory.newConnection(addresses);
        return connection;
    }

    private AutorecoveringConnection getMqConnection(Address[] addresses, String mqUserName, String mqPassword) {
        AutorecoveringConnection connection = null;
        SleepTimeCalculateUtil.SleepTimeCalculateBean sleepTimeCalculateBean = SleepTimeCalculateUtil.getSleepTimeCalculateBean();
        while (true) {
            try {
                connection = this.newConnection(addresses, mqUserName, mqPassword);
                logger.info("RabbitMqConsumer rabbitMQ connection finish.");
                break;
            }
            catch (ConnectException e) {
                logger.info("RabbitMqConsumer rabbitMQ connectException, try again: ", (Throwable)e);
            }
            catch (IOException e) {
                logger.info("RabbitMqConsumer rabbitMQ IOException, try again: ", (Throwable)e);
            }
            catch (Exception e) {
                logger.info("RabbitMqConsumer rabbitMQ Exception, try again: ", (Throwable)e);
            }
            try {
                SleepTimeCalculateUtil.calculateSleepTime(sleepTimeCalculateBean);
                logger.error("RabbitMqConsumer connect rabbitMq error, sleep {}s connect.", (Object)sleepTimeCalculateBean.getSleepTime());
                Thread.sleep(sleepTimeCalculateBean.getSleepTime() * 1000);
            }
            catch (Exception e) {}
        }
        if (null == connection) {
            this.getMqConnection(addresses, mqUserName, mqPassword);
        }
        connection.addShutdownListener(new ShutdownListener(){

            public void shutdownCompleted(ShutdownSignalException cause) {
                String hardError = "";
                String applInit = "";
                hardError = cause.isHardError() ? "connection" : "channel";
                applInit = cause.isInitiatedByApplication() ? "application" : "broker";
                logger.error("Connectivity to MQ has failed.  It was caused by " + applInit + " at the " + hardError + " level.  Reason received " + cause.getReason());
                Consts.rabbitMqConnnectionSuccess = false;
            }
        });
        Consts.rabbitMqConnnectionSuccess = true;
        return connection;
    }

    private void initQueue(String queueName) throws IOException {
        try {
            channel.queueDeclarePassive(queueName);
        }
        catch (IOException e) {
            this.declareQueue(queueName);
        }
    }

    private void createChannel() throws IOException {
        channel = connection.createChannel();
        channel.confirmSelect();
        channel.addShutdownListener(new ShutdownListener(){

            public void shutdownCompleted(ShutdownSignalException cause) {
                logger.debug("Handling channel shutdown...", (Throwable)cause);
                if (cause.isInitiatedByApplication()) {
                    logger.debug("Shutdown is initiated by application. Ignoring it.");
                } else {
                    channel = null;
                }
            }
        });
    }

    public Channel getChannel() {
        if (channel == null || !channel.isOpen()) {
            try {
                this.createChannel();
            }
            catch (IOException e) {
                logger.error("getChannel error: ", (Throwable)e);
            }
        }
        return channel;
    }

    public void declareExchange(String exchange, String routtingType) throws IOException {
        if (channel == null || !channel.isOpen()) {
            this.createChannel();
        }
        channel.exchangeDeclare(exchange, routtingType, true);
    }

    public void removeExchange(String exchange) throws IOException {
        if (channel == null) {
            this.createChannel();
        }
        channel.exchangeDelete(exchange);
    }

    public void declareQueue(String queueName) throws IOException {
        this.declareQueue(queueName, true);
    }

    public void declareQueue(String queueName, boolean durable) throws IOException {
        if (channel == null) {
            this.createChannel();
        }
        channel.queueDeclare(queueName, durable, false, false, null);
    }

    public void removeQueue(String queueName) throws IOException {
        if (channel == null) {
            this.createChannel();
        }
        channel.queueDelete(queueName);
    }

    public void bindRouting(String exchange, String queueName, String routing) throws IOException {
        if (channel == null) {
            this.createChannel();
        }
        channel.queueBind(queueName, exchange, routing);
    }

    private static class RabbitMqInitHolder {
        public static final RabbitMqInit instance = new RabbitMqInit();

        private RabbitMqInitHolder() {
        }
    }
}

