/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jxlsclient.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.xdja.jxlsclient.bean.common.Consts;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.handler.ReportLogRedisCacheHandler;
import com.xdja.jxlsclient.util.RabbitMqInit;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsgToRabbitMqUtil {
    private static final Logger logger = LoggerFactory.getLogger(SendMsgToRabbitMqUtil.class);
    public static final String EXCHANGE_NAME = "to.jxls";
    public static final String QUEUE_NAME = "jxls";

    public static void sendMessage(String routingKey, String message) throws Exception {
        if (Consts.rabbitMqInit && Consts.rabbitMqConnnectionSuccess) {
            try {
                AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().contentType("application/json").contentEncoding("UTF-8").deliveryMode(Integer.valueOf(2)).messageId(UUID.randomUUID().toString()).timestamp(new Date()).build();
                Channel channel = RabbitMqInit.getInstance().getChannel();
                SendMsgToRabbitMqUtil.checkQueueIsReady(routingKey);
                channel.basicPublish(EXCHANGE_NAME, routingKey, properties, message.getBytes());
            }
            catch (Exception e) {
                if (Consts.switchRedis) {
                    logger.info("\u53d1\u9001\u6d88\u606f\u5230rabbitMq\u5931\u8d25\uff0c\u6d88\u606f\u7f13\u5b58\u5728redis\u4e2d>>>redisKey:\u3010{}\u3011, message:\u3010{}\u3011", (Object)routingKey, (Object)message);
                    ReportLogRedisCacheHandler.cacheMessage(routingKey, message);
                }
                logger.error("\u53d1\u9001\u6d88\u606f\u5230rabbitMq\u5931\u8d25\uff0credis\u7f13\u5b58\u6d88\u606f\u6ca1\u6709\u5f00\u542f");
                throw e;
            }
        } else if (Consts.rabbitMqInit && Consts.switchRedis) {
            logger.info("rabbitMq\u8fde\u63a5\u5931\u8d25\uff0c\u6d88\u606f\u7f13\u5b58\u5728redis\u4e2d>>>redisKey:\u3010{}\u3011, message:\u3010{}\u3011", (Object)routingKey, (Object)message);
            ReportLogRedisCacheHandler.cacheMessage(routingKey, message);
        } else {
            String errorMsg = "rabbitMq\u8fde\u63a5\u5931\u8d25,redis\u7f13\u5b58\u6ca1\u6709\u5f00\u542f";
            if (!Consts.rabbitMqInit) {
                errorMsg = "rabbitMq\u6ca1\u6709\u521d\u59cb\u5316,redis\u7f13\u5b58\u6ca1\u6709\u5f00\u542f";
            }
            logger.error(errorMsg);
            throw new JxlsClientException(errorMsg);
        }
    }

    public static void sendMessage(String routingKey, Map<String, Object> headers, String message) throws Exception {
        if (Consts.rabbitMqInit && Consts.rabbitMqConnnectionSuccess) {
            try {
                Channel channel = RabbitMqInit.getInstance().getChannel();
                SendMsgToRabbitMqUtil.checkQueueIsReady(routingKey);
                AMQP.BasicProperties basicProperties = new AMQP.BasicProperties().builder().headers(headers).build();
                channel.basicPublish(EXCHANGE_NAME, routingKey, basicProperties, message.getBytes());
            }
            catch (Exception e) {
                if (Consts.switchRedis) {
                    logger.info("\u53d1\u9001\u6d88\u606f\u5230rabbitMq\u5931\u8d25\uff0c\u6d88\u606f\u7f13\u5b58\u5728redis\u4e2d>>>redisKey:\u3010{}\u3011, message:\u3010{}\u3011", (Object)routingKey, (Object)message);
                    ReportLogRedisCacheHandler.cacheMessage(routingKey, message);
                }
                logger.error("\u53d1\u9001\u6d88\u606f\u5230rabbitMq\u5931\u8d25\uff0credis\u7f13\u5b58\u6d88\u606f\u6ca1\u6709\u5f00\u542f");
                throw e;
            }
        } else if (Consts.rabbitMqInit && Consts.switchRedis) {
            logger.info("rabbitMq\u8fde\u63a5\u5931\u8d25\uff0c\u6d88\u606f\u7f13\u5b58\u5728redis\u4e2d>>>redisKey:\u3010{}\u3011, message:\u3010{}\u3011", (Object)routingKey, (Object)message);
            ReportLogRedisCacheHandler.cacheMessage(routingKey, message);
        } else {
            String errorMsg = "rabbitMq\u8fde\u63a5\u5931\u8d25,redis\u7f13\u5b58\u6ca1\u6709\u5f00\u542f";
            if (!Consts.rabbitMqInit) {
                errorMsg = "rabbitMq\u6ca1\u6709\u521d\u59cb\u5316,redis\u7f13\u5b58\u6ca1\u6709\u5f00\u542f";
            }
            logger.error(errorMsg);
            throw new JxlsClientException(errorMsg);
        }
    }

    private static void checkQueueIsReady(String routingKey) throws IOException {
        Channel channel = RabbitMqInit.getInstance().getChannel();
        try {
            channel.exchangeDeclarePassive(EXCHANGE_NAME);
        }
        catch (Exception e) {
            RabbitMqInit.getInstance().declareExchange(EXCHANGE_NAME, "topic");
        }
        try {
            channel.queueDeclarePassive(QUEUE_NAME);
        }
        catch (IOException e) {
            RabbitMqInit.getInstance().declareQueue(QUEUE_NAME);
            RabbitMqInit.getInstance().bindRouting(EXCHANGE_NAME, QUEUE_NAME, routingKey);
            return;
        }
        RabbitMqInit.getInstance().bindRouting(EXCHANGE_NAME, QUEUE_NAME, routingKey);
        logger.info("RabbitMq\u7ed1\u5b9aexchange_name:\u3010{}\u3011, queue_name:\u3010{}\u3011, routingKey:{}", new Object[]{EXCHANGE_NAME, QUEUE_NAME, routingKey});
    }
}

