package com.xdja.lbs;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import static com.xdja.lbs.config.Constants.ACTION_CHANGE_INTERVAL;
import static com.xdja.lbs.config.Constants.ACTION_START_SERVICE;
import static com.xdja.lbs.config.Constants.ACTION_STOP_SERVICE;
import static com.xdja.lbs.config.Constants.EXTRA_UPLOAD_INTERVAL;

public class LbsManager {
    /**
     * 开启定位服务
     *
     * @param context
     */
    public static void startLbsService(Context context) {
        startLbsService(context, 2);
    }

    /**
     * 开启定位服务，并设定定位上传间隔
     *
     * @param context
     * @param interval
     */
    public static void startLbsService(Context context, int interval) {
        Intent intent = new Intent();
        intent.setAction(ACTION_START_SERVICE);
        intent.setPackage(context.getPackageName());
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_UPLOAD_INTERVAL, interval);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    /**
     * 修改定位间隔
     *
     * @param context
     * @param interval 定位间隔，单位s
     */
    public static void changeUploadInterval(Context context, int interval) {
        Intent intent = new Intent();
        intent.setAction(ACTION_CHANGE_INTERVAL);
        intent.setPackage(context.getPackageName());
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_UPLOAD_INTERVAL, interval);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    /**
     * 停止定位上传服务
     *
     * @param context
     */
    public static void stopLbsService(Context context) {
        Intent intent = new Intent();
        intent.setAction(ACTION_STOP_SERVICE);
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }
}
