package com.xdja.lbs.provider;

import android.content.Context;

import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.xdja.lbs.transform.BDTransformer;

/**
 * 提供及管理百度定位
 *
 * @author Guojie
 */
public class BaiduProvider extends BaseProvider implements IProvider, BDLocationListener {
    private LocationClient mLocationClient = null;
    private LocationClientOption option;

    public BaiduProvider(Context context,int priority) {
        super(context,priority);
        mTransformer = new BDTransformer();
        timeoutMills=20*1000;
    }

    @Override
    public void initProvide() {
        option = new LocationClientOption();
        option.setCoorType("bd09ll");
        option.setScanSpan(5 * 1000);
        option.setOpenGps(true);
        option.setIsNeedAddress(true);
        option.setIsNeedLocationDescribe(true);
        option.setNeedDeviceDirect(true);
        option.setLocationNotify(true);
        option.setIsNeedAltitude(true);
        option.setWifiCacheTimeOut(60 * 1000);
//        option.setOpenAutoNotifyMode(3 * 1000, 1, LocationClientOption.LOC_SENSITIVITY_HIGHT);
        option.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
        mLocationClient = new LocationClient(mContext);
        mLocationClient.setLocOption(option);
    }

    @Override
    public boolean startLocation() {
        if (mLocationClient == null) {
            initProvide();
        }
        mLocationClient.registerLocationListener(this);
        mLocationClient.start();
        super.startLocation();
        return true;
    }

    @Override
    public void stopLocation() {
        if (mLocationClient != null) {
            mLocationClient.unRegisterLocationListener(this);
            mLocationClient.stop();
        }
        super.stopLocation();
    }

    @Override
    public void onDestroy() {
        stopLocation();
        mLocationClient = null;
        option = null;
    }

    @Override
    public void onReceiveLocation(BDLocation bdLocation) {
        boolean isAvailable = bdLocation != null
                && (bdLocation.getLocType() == 61 || bdLocation.getLocType() == 66 || bdLocation.getLocType() == 161);
        if (mXdjaLocationListener != null) {
            if (isAvailable) {
                lastUpdateTimeMills = System.currentTimeMillis();
                xLocation = mTransformer.transform(bdLocation);
                mXdjaLocationListener.onLocationChanged(xLocation);
            } else {
                mXdjaLocationListener.onLocationError(bdLocation.getLocTypeDescription());
            }
        }

    }
}
