package com.xdja.lbs.transform;

import android.location.Location;
import android.text.TextUtils;
import android.util.Log;

import com.amap.api.location.AMapLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.BaseProvider;

import java.text.SimpleDateFormat;


/**
 * 高德定位转换
 *
 * @author Guojie
 */
public class AMapTransformer implements ITransformer<AMapLocation> {
    private final String TAG = getClass().getSimpleName();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Override
    public XLocation transform(AMapLocation aMapLocation) {
//        Log.d(TAG, "getLongitude:" + aMapLocation.getLongitude());
//        Log.d(TAG, "getLatitude:" + aMapLocation.getLatitude());
//        Log.d(TAG, "getCountry:" + aMapLocation.getCountry());
//        Log.d(TAG, "getProvince:" + aMapLocation.getProvince());
//        Log.d(TAG, "getCityCode:" + aMapLocation.getCityCode());
//        Log.d(TAG, "getCity:" + aMapLocation.getCity());
//        Log.d(TAG, "getDistrict:" + aMapLocation.getDistrict());
//        Log.d(TAG, "getAdCode:" + aMapLocation.getAdCode());
//        Log.d(TAG, "getAddress:" + aMapLocation.getAddress());
//        Log.d(TAG, "getStreet:" + aMapLocation.getStreet());
//        Log.d(TAG, "getStreetNum:" + aMapLocation.getStreetNum());
//        Log.d(TAG, "getDescription:" + aMapLocation.getDescription());
//        Log.d(TAG, "getTime:" + aMapLocation.getTime());
        XLocation xLocation = new XLocation();
        xLocation.setLocationSource(BaseProvider.AMAP_PROVIDER);
        xLocation.setLocationSourceDescription("高德定位");
        xLocation.setProvider(aMapLocation.getProvider());
        xLocation.setLongitude(aMapLocation.getLongitude());
        xLocation.setLatitude(aMapLocation.getLatitude());
        xLocation.setAltitude(aMapLocation.getAltitude());
        xLocation.setSpeed(aMapLocation.getSpeed());
        xLocation.setCountry(aMapLocation.getCountry());
        xLocation.setProvince(aMapLocation.getProvince());
        xLocation.setCity(aMapLocation.getCity());
        xLocation.setDistrict(aMapLocation.getDistrict());
        xLocation.setAdCode(aMapLocation.getAdCode());
        xLocation.setAddress(aMapLocation.getAddress());
        xLocation.setStreet(aMapLocation.getStreet());
        xLocation.setStreetNum(aMapLocation.getStreetNum());
        xLocation.setDescription(aMapLocation.getDescription());
        xLocation.setTime(aMapLocation.getTime());
        xLocation.setTimeStr(simpleDateFormat.format(aMapLocation.getTime()));
        return xLocation;
    }
}
