package com.xdja.lbs.transform;

import android.location.Location;
import android.os.Environment;

import com.blankj.utilcode.util.FileIOUtils;
import com.blankj.utilcode.util.FileUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.BaseProvider;

import java.text.SimpleDateFormat;

/**
 * 原生GPS转换
 *
 * @author Guojie
 */
public class NativeTransformer implements ITransformer<Location> {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public XLocation transform(Location location) {
        XLocation xLocation = new XLocation();
        xLocation.setLocationSource(BaseProvider.GPS_PROVIDER);
        xLocation.setLocationSourceDescription("GPS定位");
        xLocation.setProvider(location.getProvider());
        xLocation.setLongitude(location.getLongitude());
        xLocation.setLatitude(location.getLatitude());
        xLocation.setTime(location.getTime());
        xLocation.setTimeStr(simpleDateFormat.format(location.getTime()));
        xLocation.setAltitude(location.getAltitude());
        xLocation.setSpeed(location.getSpeed());
        return xLocation;
    }
}
