/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AppExecutors {
    private Executor diskIO;
    private Executor networkIO;
    private Executor mainThread;
    protected static AppExecutors appExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppExecutors getInstance() {
        if (appExecutors != null) return appExecutors;
        Class<AppExecutors> clazz = AppExecutors.class;
        synchronized (AppExecutors.class) {
            if (appExecutors != null) return appExecutors;
            appExecutors = new AppExecutors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return appExecutors;
        }
    }

    public AppExecutors() {
        this(Executors.newSingleThreadExecutor(), Executors.newFixedThreadPool(5), new MainThreadHandler());
    }

    public AppExecutors(Executor diskIO, Executor networkIO, Executor mainThread) {
        this.diskIO = diskIO;
        this.networkIO = networkIO;
        this.mainThread = mainThread;
    }

    public Executor getDiskIO() {
        return this.diskIO;
    }

    public Executor getNetworkIO() {
        return this.networkIO;
    }

    public Executor getMainThread() {
        return this.mainThread;
    }

    private static class MainThreadHandler
    implements Executor {
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private MainThreadHandler() {
        }

        @Override
        public void execute(Runnable command) {
            this.mainHandler.post(command);
        }
    }
}

