/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.UploadLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.AMapProvider;
import com.xdja.lbs.provider.BaiduProvider;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.CellProvider;
import com.xdja.lbs.provider.GpsProvider;
import com.xdja.lbs.tools.AssetsProperties;
import com.xdja.lbs.tools.PhoneTools;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LbsService
extends Service
implements XdjaLocationListener {
    private final String TAG = this.getClass().getSimpleName();
    private ScheduledExecutorService executorService;
    private ScheduledExecutorService dispatchService;
    private UploadLocationExecutor locationExecutor;
    private DispatchProviderExecutor dispatchExecutor;
    private BaseProvider gpsProvider;
    private BaseProvider aMapProvider;
    private BaseProvider bdProvider;
    private BaseProvider bsProvider;
    private int interval;
    private XLocation xLocation;
    private boolean isExecutorRunning;
    private boolean isDispatchRunning;
    private Gson gson;
    private AssetsProperties assetsProperties;
    private LocationManager locationManager;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.gson = new GsonBuilder().create();
        this.locationManager = (LocationManager)this.getSystemService("location");
        this.assetsProperties = new AssetsProperties((Context)this, "config.properties");
        this.locationExecutor = new UploadLocationExecutor();
        this.dispatchExecutor = new DispatchProviderExecutor();
        this.gpsProvider = new GpsProvider((Context)this, 0);
        this.aMapProvider = new AMapProvider((Context)this, 1);
        this.bdProvider = new BaiduProvider((Context)this, 2);
        this.bsProvider = new CellProvider((Context)this, 3);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent.getAction() != null) {
            Bundle bundle = intent.getExtras();
            switch (intent.getAction()) {
                case "android.intent.action.lbs.START_SERVICE": {
                    if (bundle != null) {
                        this.interval = bundle.getInt("upload_interval", 2);
                    }
                    if (this.isExecutorRunning) {
                        this.executorService.shutdownNow();
                    }
                    if (this.isDispatchRunning) {
                        this.dispatchService.shutdownNow();
                    }
                    this.enableProvider(this.gpsProvider, true);
                    this.executorService = Executors.newScheduledThreadPool(5);
                    this.executorService.scheduleAtFixedRate(this.locationExecutor, 0L, this.interval <= 2 ? 2L : (long)this.interval, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    this.dispatchService = Executors.newSingleThreadScheduledExecutor();
                    this.executorService.scheduleAtFixedRate(this.dispatchExecutor, 2L, 2L, TimeUnit.SECONDS);
                    this.isDispatchRunning = true;
                    break;
                }
                case "android.intent.action.lbs.CHANGE_INTERVAL": {
                    int intervalChange = intent.getIntExtra("upload_interval", 2);
                    if (!this.isExecutorRunning) break;
                    this.executorService.shutdownNow();
                    this.executorService = Executors.newScheduledThreadPool(5);
                    this.executorService.scheduleAtFixedRate(this.locationExecutor, 0L, intervalChange <= 2 ? 2L : (long)intervalChange, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    break;
                }
                case "android.intent.action.lbs.STOP_SERVICE": {
                    this.stopService();
                    break;
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void enableProvider(BaseProvider baseProvider, boolean enable) {
        if (enable) {
            baseProvider.setLocationListener(this);
            boolean ret = baseProvider.startLocation();
            Log.i((String)this.TAG, (String)("enableProvider \u5f00\u542f\u5b9a\u4f4d\u65b9\u5f0f\uff1a" + baseProvider.getClass().getSimpleName() + " \u5f00\u542f\u7ed3\u679c\uff1a" + ret));
        } else {
            baseProvider.removeLocationListener();
            baseProvider.stopLocation();
            Log.i((String)this.TAG, (String)("enableProvider \u5173\u95ed\u5b9a\u4f4d\u65b9\u5f0f\uff1a" + baseProvider.getClass().getSimpleName()));
        }
    }

    @Override
    public void onLocationChanged(XLocation xLocation) {
        Log.d((String)this.TAG, (String)("onLocationChanged,location provider:" + xLocation.getLocationSource()));
        this.xLocation = xLocation;
        Intent intent = new Intent();
        intent.setAction("com.xdja.intent.action.location_changed");
        intent.putExtra("location", this.gson.toJson((Object)xLocation));
        this.sendBroadcast(intent);
    }

    @Override
    public void onLocationError(String errMessage) {
        Log.d((String)this.TAG, (String)("onLocationError:" + errMessage));
    }

    private void stopService() {
        this.gpsProvider.onDestroy();
        this.bsProvider.onDestroy();
        this.aMapProvider.onDestroy();
        this.bdProvider.onDestroy();
        if (this.isExecutorRunning) {
            this.executorService.shutdownNow();
        }
        if (this.isDispatchRunning) {
            this.dispatchService.shutdownNow();
        }
        this.isExecutorRunning = false;
        this.isDispatchRunning = false;
        this.stopSelf();
    }

    private BaseProvider dispatchProvider(BaseProvider checkProvider) {
        BaseProvider nextProvider = null;
        if (checkProvider instanceof GpsProvider) {
            nextProvider = this.bsProvider;
        } else if (checkProvider instanceof CellProvider) {
            nextProvider = this.bdProvider;
        } else if (checkProvider instanceof BaiduProvider) {
            nextProvider = this.aMapProvider;
        } else {
            return null;
        }
        if (checkProvider.isTimeOut()) {
            if (!nextProvider.isOpen()) {
                this.enableProvider(nextProvider, true);
            }
        } else {
            if (checkProvider instanceof GpsProvider) {
                if (this.bsProvider.isOpen()) {
                    this.enableProvider(this.bsProvider, false);
                }
                if (this.bdProvider.isOpen()) {
                    this.enableProvider(this.bdProvider, false);
                }
                if (this.aMapProvider.isOpen()) {
                    this.enableProvider(this.aMapProvider, false);
                }
            } else if (checkProvider instanceof CellProvider) {
                if (this.bdProvider.isOpen()) {
                    this.enableProvider(this.bdProvider, false);
                }
                if (this.aMapProvider.isOpen()) {
                    this.enableProvider(this.aMapProvider, false);
                }
            } else if (checkProvider instanceof BaiduProvider && this.aMapProvider.isOpen()) {
                this.enableProvider(this.aMapProvider, false);
            }
            return null;
        }
        return this.dispatchProvider(nextProvider);
    }

    private class DispatchProviderExecutor
    implements Runnable {
        private DispatchProviderExecutor() {
        }

        @Override
        public void run() {
            if (!LbsService.this.gpsProvider.isOpen() && LbsService.this.locationManager.isProviderEnabled("gps")) {
                LbsService.this.enableProvider(LbsService.this.gpsProvider, true);
            }
            LbsService.this.dispatchProvider(LbsService.this.gpsProvider);
        }
    }

    private class UploadLocationExecutor
    implements Runnable {
        private UploadLocationExecutor() {
        }

        @Override
        @SuppressLint(value={"MissingPermission"})
        public void run() {
            if (LbsService.this.xLocation != null) {
                try {
                    UploadLocation uploadLocation = new UploadLocation();
                    uploadLocation.setImei(PhoneTools.getIMEI((Context)LbsService.this));
                    uploadLocation.setLon(LbsService.this.xLocation.getLongitude());
                    uploadLocation.setLat(LbsService.this.xLocation.getLatitude());
                    uploadLocation.setCountry(LbsService.this.xLocation.getCountry());
                    uploadLocation.setProvince(LbsService.this.xLocation.getProvince());
                    uploadLocation.setCity(LbsService.this.xLocation.getCity());
                    uploadLocation.setDistrict(LbsService.this.xLocation.getDistrict());
                    uploadLocation.setStreet(LbsService.this.xLocation.getStreet());
                    uploadLocation.setDescription(LbsService.this.xLocation.getAddress());
                    uploadLocation.setSource(LbsService.this.xLocation.getLocationSource());
                    uploadLocation.setTime(LbsService.this.xLocation.getTime());
                    String message = LbsService.this.gson.toJson((Object)uploadLocation);
                    Log.d((String)LbsService.this.TAG, (String)("sendStr:" + message));
                    InetAddress inetAddress = InetAddress.getByName(LbsService.this.assetsProperties.getString("uploadHost", ""));
                    byte[] buf = message.getBytes();
                    DatagramSocket datagramSocket = new DatagramSocket();
                    DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length, inetAddress, LbsService.this.assetsProperties.getInt("uploadPort", 1080));
                    datagramSocket.send(datagramPacket);
                    datagramSocket.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

