/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.UploadLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.AMapProvider;
import com.xdja.lbs.provider.BaiduProvider;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.CellProvider;
import com.xdja.lbs.provider.GpsProvider;
import com.xdja.lbs.tools.AssetsProperties;
import com.xdja.lbs.tools.PhoneTools;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LbsServiceBak
extends Service
implements XdjaLocationListener {
    private final String TAG = this.getClass().getSimpleName();
    private ScheduledExecutorService executorService;
    private UploadLocationExecutor locationExecutor;
    private BaseProvider gpsProvider;
    private BaseProvider aMapProvider;
    private BaseProvider bdProvider;
    private BaseProvider bsProvider;
    private XLocation xLocation;
    private boolean isExecutorRunning;
    private Gson gson;
    private AssetsProperties assetsProperties;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.gson = new GsonBuilder().create();
        this.assetsProperties = new AssetsProperties((Context)this, "config.properties");
        this.locationExecutor = new UploadLocationExecutor();
        this.gpsProvider = new GpsProvider((Context)this, 0);
        this.aMapProvider = new AMapProvider((Context)this, 1);
        this.bdProvider = new BaiduProvider((Context)this, 2);
        this.bsProvider = new CellProvider((Context)this, 3);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        if (intent.getAction() != null) {
            switch (intent.getAction()) {
                case "android.intent.action.lbs.START_SERVICE": {
                    if (this.isExecutorRunning) {
                        this.executorService.shutdownNow();
                    }
                    this.enableProvider(intent.getExtras());
                    int intervalStart = intent.getIntExtra("upload_interval", 2);
                    this.executorService = Executors.newScheduledThreadPool(5);
                    this.executorService.scheduleAtFixedRate(this.locationExecutor, 0L, intervalStart <= 2 ? 2L : (long)intervalStart, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    break;
                }
                case "android.intent.action.lbs.CHANGE_INTERVAL": {
                    int intervalChange = intent.getIntExtra("upload_interval", 2);
                    if (!this.isExecutorRunning) break;
                    this.executorService.shutdownNow();
                    this.executorService = Executors.newScheduledThreadPool(5);
                    this.executorService.scheduleAtFixedRate(this.locationExecutor, 0L, intervalChange <= 2 ? 2L : (long)intervalChange, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    break;
                }
                case "android.intent.action.lbs.ENABLE_PROVIDER": {
                    if (!this.isExecutorRunning) break;
                    this.enableProvider(intent.getExtras());
                    break;
                }
                case "android.intent.action.lbs.STOP_SERVICE": {
                    this.stopService();
                    break;
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void enableProvider(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getBoolean("gps_enable")) {
                this.gpsProvider.setLocationListener(this);
                this.gpsProvider.startLocation();
            } else {
                this.gpsProvider.removeLocationListener();
                this.gpsProvider.stopLocation();
            }
            if (bundle.getBoolean("bs_enable")) {
                this.bsProvider.setLocationListener(this);
                this.bsProvider.startLocation();
            } else {
                this.bsProvider.removeLocationListener();
                this.bsProvider.stopLocation();
            }
            if (bundle.getBoolean("amap_enable")) {
                this.aMapProvider.setLocationListener(this);
                this.aMapProvider.startLocation();
            } else {
                this.aMapProvider.removeLocationListener();
                this.aMapProvider.stopLocation();
            }
            if (bundle.getBoolean("baidu_enable")) {
                this.bdProvider.setLocationListener(this);
                this.bdProvider.startLocation();
            } else {
                this.bdProvider.removeLocationListener();
                this.bdProvider.stopLocation();
            }
        }
    }

    @Override
    public void onLocationChanged(XLocation xLocation) {
        Log.d((String)this.TAG, (String)("onLocationChanged,location provider:" + xLocation.getLocationSource()));
        this.xLocation = xLocation;
        Intent intent = new Intent();
        intent.setAction("com.xdja.intent.action.location_changed");
        intent.putExtra("location", this.gson.toJson((Object)xLocation));
        this.sendBroadcast(intent);
    }

    @Override
    public void onLocationError(String errMessage) {
        Log.d((String)this.TAG, (String)("onLocationError:" + errMessage));
    }

    private void stopService() {
        this.gpsProvider.onDestroy();
        this.bsProvider.onDestroy();
        this.aMapProvider.onDestroy();
        this.bdProvider.onDestroy();
        if (this.isExecutorRunning) {
            this.executorService.shutdownNow();
        }
        this.isExecutorRunning = false;
        this.stopSelf();
    }

    private class UploadLocationExecutor
    implements Runnable {
        private UploadLocationExecutor() {
        }

        @Override
        public void run() {
            if (LbsServiceBak.this.xLocation != null) {
                try {
                    UploadLocation uploadLocation = new UploadLocation();
                    uploadLocation.setImei(PhoneTools.getIMEI((Context)LbsServiceBak.this));
                    uploadLocation.setLon(LbsServiceBak.this.xLocation.getLongitude());
                    uploadLocation.setLat(LbsServiceBak.this.xLocation.getLatitude());
                    uploadLocation.setCountry(LbsServiceBak.this.xLocation.getCountry());
                    uploadLocation.setProvince(LbsServiceBak.this.xLocation.getProvince());
                    uploadLocation.setCity(LbsServiceBak.this.xLocation.getCity());
                    uploadLocation.setDistrict(LbsServiceBak.this.xLocation.getDistrict());
                    uploadLocation.setStreet(LbsServiceBak.this.xLocation.getStreet());
                    uploadLocation.setDescription(LbsServiceBak.this.xLocation.getAddress());
                    uploadLocation.setSource(LbsServiceBak.this.xLocation.getLocationSource());
                    uploadLocation.setTime(LbsServiceBak.this.xLocation.getTime());
                    String message = LbsServiceBak.this.gson.toJson((Object)uploadLocation);
                    Log.d((String)LbsServiceBak.this.TAG, (String)("sendStr:" + message));
                    InetAddress inetAddress = InetAddress.getByName(LbsServiceBak.this.assetsProperties.getString("uploadHost", ""));
                    byte[] buf = message.getBytes();
                    DatagramSocket datagramSocket = new DatagramSocket();
                    DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length, inetAddress, LbsServiceBak.this.assetsProperties.getInt("uploadPort", 1080));
                    datagramSocket.send(datagramPacket);
                    datagramSocket.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

