/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.provider;

import android.content.Context;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.IProvider;
import com.xdja.lbs.transform.BDTransformer;

public class BaiduProvider
extends BaseProvider
implements IProvider,
BDLocationListener {
    private LocationClient mLocationClient = null;
    private LocationClientOption option;

    public BaiduProvider(Context context, int priority) {
        super(context, priority);
        this.mTransformer = new BDTransformer();
        this.timeoutMills = 20000L;
    }

    @Override
    public void initProvide() {
        this.option = new LocationClientOption();
        this.option.setCoorType("bd09ll");
        this.option.setScanSpan(5000);
        this.option.setOpenGps(true);
        this.option.setIsNeedAddress(true);
        this.option.setIsNeedLocationDescribe(true);
        this.option.setNeedDeviceDirect(true);
        this.option.setLocationNotify(true);
        this.option.setIsNeedAltitude(true);
        this.option.setWifiCacheTimeOut(60000);
        this.option.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
        this.mLocationClient = new LocationClient(this.mContext);
        this.mLocationClient.setLocOption(this.option);
    }

    @Override
    public boolean startLocation() {
        if (this.mLocationClient == null) {
            this.initProvide();
        }
        this.mLocationClient.registerLocationListener((BDLocationListener)this);
        this.mLocationClient.start();
        super.startLocation();
        return true;
    }

    @Override
    public void stopLocation() {
        if (this.mLocationClient != null) {
            this.mLocationClient.unRegisterLocationListener((BDLocationListener)this);
            this.mLocationClient.stop();
        }
        super.stopLocation();
    }

    @Override
    public void onDestroy() {
        this.removeLocationListener();
        this.stopLocation();
        this.mLocationClient = null;
        this.option = null;
    }

    public void onReceiveLocation(BDLocation bdLocation) {
        boolean isAvailable;
        boolean bl = isAvailable = bdLocation != null && (bdLocation.getLocType() == 61 || bdLocation.getLocType() == 66 || bdLocation.getLocType() == 161);
        if (this.mXdjaLocationListener != null) {
            if (isAvailable) {
                this.lastUpdateTimeMills = System.currentTimeMillis();
                this.xLocation = this.mTransformer.transform(bdLocation);
                this.mXdjaLocationListener.onLocationChanged(this.xLocation);
            } else {
                this.mXdjaLocationListener.onLocationError(bdLocation.getLocTypeDescription());
            }
        }
    }
}

