/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.provider;

import android.content.Context;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.FileIOUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.google.gson.Gson;
import com.xdja.lbs.AppExecutors;
import com.xdja.lbs.location.BSLocation;
import com.xdja.lbs.location.BSLocationT;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.IProvider;
import com.xdja.lbs.tools.AssetsProperties;
import com.xdja.lbs.tools.HttpRequest;
import com.xdja.lbs.transform.BSTransformerT;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CellProvider
extends BaseProvider
implements IProvider {
    private TelephonyManager telephonyManager;
    private String mcc;
    private String mnc;
    private int networkType;
    private int phoneType;
    private Gson gson;
    private AssetsProperties assetsProperties;
    private ScheduledExecutorService executorService;
    private UpdateLocationExecutor locationExecutor;
    private boolean isExecutor;
    private String serverIP;
    private int serverPort;
    private PhoneStateListener phoneStateListener = new PhoneStateListener(){

        public void onCellLocationChanged(CellLocation location) {
            super.onCellLocationChanged(location);
            Log.d((String)CellProvider.this.TAG, (String)"onCellLocationChanged");
            if (location instanceof GsmCellLocation) {
                GsmCellLocation gsmCellLocation = (GsmCellLocation)location;
                Log.d((String)CellProvider.this.TAG, (String)("gsmCellLocation=" + gsmCellLocation.getCid()));
            } else if (location instanceof CdmaCellLocation) {
                CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)location;
                Log.d((String)CellProvider.this.TAG, (String)("cdmaCellLocation=" + cdmaCellLocation.getBaseStationLatitude()));
            }
            CellProvider.this.getAllCellInfo();
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            Log.d((String)CellProvider.this.TAG, (String)("onSignalStrengthsChanged=" + signalStrength.getGsmSignalStrength()));
            CellProvider.this.getAllCellInfo();
        }

        public void onCellInfoChanged(List<CellInfo> cellInfo) {
            super.onCellInfoChanged(cellInfo);
            Log.d((String)CellProvider.this.TAG, (String)"onCellInfoChanged");
            CellProvider.this.getAllCellInfo();
        }
    };

    public CellProvider(Context context, int priority) {
        super(context, priority);
        this.gson = new Gson();
        this.mTransformer = new BSTransformerT();
        this.assetsProperties = new AssetsProperties(this.mContext, "config.properties");
        this.timeoutMills = 20000L;
    }

    public CellProvider(Context context, String serverIP, int serverPort) {
        super(context);
        this.serverIP = serverIP;
        this.serverPort = serverPort;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public void initProvide() {
        this.telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String operator = this.telephonyManager.getNetworkOperator();
        if (!TextUtils.isEmpty((CharSequence)operator)) {
            this.mcc = operator.substring(0, 3);
            this.mnc = operator.substring(3);
        }
        this.networkType = this.telephonyManager.getNetworkType();
        this.phoneType = this.telephonyManager.getPhoneType();
        this.executorService = Executors.newScheduledThreadPool(5);
        this.locationExecutor = new UpdateLocationExecutor();
        this.isExecutor = false;
    }

    @Override
    public boolean startLocation() {
        this.openTimeMills = System.currentTimeMillis();
        this.isOpen = true;
        if (this.telephonyManager == null) {
            this.initProvide();
        }
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.e((String)this.TAG, (String)"ACCESS_COARSE_LOCATION permission not granted error");
            if (this.mXdjaLocationListener != null) {
                this.mXdjaLocationListener.onLocationError("\u5f00\u542f\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a\u672a\u6388\u4e88\u76f8\u5173\u6743\u9650");
            }
            return false;
        }
        this.telephonyManager.listen(this.phoneStateListener, 16);
        if (!this.isExecutor) {
            this.executorService.scheduleAtFixedRate(this.locationExecutor, 0L, 10L, TimeUnit.SECONDS);
            this.isExecutor = true;
        }
        Log.d((String)this.TAG, (String)(this.getClass().getSimpleName() + " start"));
        return true;
    }

    @Override
    public void stopLocation() {
        if (this.telephonyManager != null) {
            this.telephonyManager.listen(this.phoneStateListener, 0);
        }
        if (this.isExecutor) {
            this.executorService.shutdownNow();
        }
        this.isExecutor = false;
        this.executorService = null;
        this.locationExecutor = null;
        this.telephonyManager = null;
        super.stopLocation();
    }

    @Override
    public void onDestroy() {
        this.removeLocationListener();
        this.stopLocation();
    }

    private void getAllCellInfo() {
        List infoLists;
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.e((String)this.TAG, (String)"ACCESS_FINE_LOCATION && ACCESS_COARSE_LOCATION permission not granted error");
            return;
        }
        if (this.telephonyManager != null && (infoLists = this.telephonyManager.getAllCellInfo()) != null && infoLists.size() > 0) {
            this.requestLocationFromNet(this.getBSParams(infoLists));
        }
    }

    private String getBSParams(List<CellInfo> infoLists) {
        StringBuilder sbFilter = new StringBuilder();
        StringBuilder sbAll = new StringBuilder();
        for (int index = 0; index < infoLists.size(); ++index) {
            CellInfo cellInfo = infoLists.get(index);
            if (cellInfo instanceof CellInfoCdma) {
                CellInfoCdma cellInfoCdma = (CellInfoCdma)cellInfo;
                CellIdentityCdma cellIdentityCdma = cellInfoCdma.getCellIdentity();
                if (this.isAvailableCdmaCell(cellIdentityCdma.getSystemId(), cellIdentityCdma.getNetworkId(), cellIdentityCdma.getBasestationId())) {
                    if (sbFilter.length() > 0) {
                        sbFilter.append(";");
                    }
                    sbFilter.append(cellIdentityCdma.getSystemId() + ",");
                    sbFilter.append(cellIdentityCdma.getNetworkId() + ",");
                    sbFilter.append(cellIdentityCdma.getBasestationId() + ",");
                    sbFilter.append(cellInfoCdma.getCellSignalStrength().getDbm());
                }
                if (sbAll.length() > 1) {
                    sbAll.append(";");
                }
                sbAll.append(cellIdentityCdma.getSystemId() + ",");
                sbAll.append(cellIdentityCdma.getNetworkId() + ",");
                sbAll.append(cellIdentityCdma.getBasestationId() + ",");
                sbAll.append(cellInfoCdma.getCellSignalStrength().getDbm());
                continue;
            }
            if (cellInfo instanceof CellInfoLte) {
                CellInfoLte cellInfoLte = (CellInfoLte)cellInfo;
                CellIdentityLte cellIdentityLte = cellInfoLte.getCellIdentity();
                if (this.isAvailableCell("lte", cellIdentityLte.getMcc(), cellIdentityLte.getMnc(), cellIdentityLte.getTac(), cellIdentityLte.getCi())) {
                    if (sbFilter.length() > 0) {
                        sbFilter.append(";");
                    }
                    sbFilter.append(cellIdentityLte.getMcc() + ",");
                    sbFilter.append(cellIdentityLte.getMnc() + ",");
                    sbFilter.append(cellIdentityLte.getTac() + ",");
                    sbFilter.append(cellIdentityLte.getCi() + ",");
                    sbFilter.append(cellInfoLte.getCellSignalStrength().getDbm());
                }
                if (sbAll.length() > 0) {
                    sbAll.append(";");
                }
                sbAll.append(cellIdentityLte.getMcc() + ",");
                sbAll.append(cellIdentityLte.getMnc() + ",");
                sbAll.append(cellIdentityLte.getTac() + ",");
                sbAll.append(cellIdentityLte.getCi() + ",");
                sbAll.append(cellInfoLte.getCellSignalStrength().getDbm());
                continue;
            }
            if (cellInfo instanceof CellInfoGsm) {
                CellInfoGsm cellInfoGsm = (CellInfoGsm)cellInfo;
                CellIdentityGsm cellIdentityGsm = cellInfoGsm.getCellIdentity();
                if (this.isAvailableCell("gsm", cellIdentityGsm.getMcc(), cellIdentityGsm.getMnc(), cellIdentityGsm.getLac(), cellIdentityGsm.getCid())) {
                    if (sbFilter.length() > 0) {
                        sbFilter.append(";");
                    }
                    sbFilter.append(cellIdentityGsm.getMcc() + ",");
                    sbFilter.append(cellIdentityGsm.getMnc() + ",");
                    sbFilter.append(cellIdentityGsm.getLac() + ",");
                    sbFilter.append(cellIdentityGsm.getCid() + ",");
                    sbFilter.append(cellInfoGsm.getCellSignalStrength().getDbm());
                }
                if (sbAll.length() > 0) {
                    sbAll.append(";");
                }
                sbAll.append(cellIdentityGsm.getMcc() + ",");
                sbAll.append(cellIdentityGsm.getMnc() + ",");
                sbAll.append(cellIdentityGsm.getLac() + ",");
                sbAll.append(cellIdentityGsm.getCid() + ",");
                sbAll.append(cellInfoGsm.getCellSignalStrength().getDbm());
                continue;
            }
            if (!(cellInfo instanceof CellInfoWcdma)) continue;
            CellInfoWcdma cellInfoWcdma = (CellInfoWcdma)cellInfo;
            cellInfoWcdma.getCellSignalStrength();
            CellIdentityWcdma cellIdentityWcdma = cellInfoWcdma.getCellIdentity();
            if (this.isAvailableCell("umts", cellIdentityWcdma.getMcc(), cellIdentityWcdma.getMnc(), cellIdentityWcdma.getLac(), cellIdentityWcdma.getCid())) {
                if (sbFilter.length() > 0) {
                    sbFilter.append(";");
                }
                sbFilter.append(cellIdentityWcdma.getMcc() + ",");
                sbFilter.append(cellIdentityWcdma.getMnc() + ",");
                sbFilter.append(cellIdentityWcdma.getLac() + ",");
                sbFilter.append(cellIdentityWcdma.getCid() + ",");
                sbFilter.append(cellInfoWcdma.getCellSignalStrength().getDbm());
            }
            if (sbAll.length() > 0) {
                sbAll.append(";");
            }
            sbAll.append(cellIdentityWcdma.getMcc() + ",");
            sbAll.append(cellIdentityWcdma.getMnc() + ",");
            sbAll.append(cellIdentityWcdma.getLac() + ",");
            sbAll.append(cellIdentityWcdma.getCid() + ",");
            sbAll.append(cellInfoWcdma.getCellSignalStrength().getDbm());
        }
        FileIOUtils.writeFileFromString((String)(Environment.getExternalStorageDirectory() + "/LbsServiceBak/AllCellInfo.txt"), (String)(TimeUtils.getNowString() + ": " + sbAll.toString() + "\n\r"), (boolean)true);
        FileIOUtils.writeFileFromString((String)(Environment.getExternalStorageDirectory() + "/LbsServiceBak/FilterCellInfo.txt"), (String)(TimeUtils.getNowString() + ": " + sbFilter.toString() + "\n\r"), (boolean)true);
        Log.d((String)this.TAG, (String)("filter bs=" + sbFilter.toString()));
        Log.d((String)this.TAG, (String)("all bs=" + sbAll.toString()));
        return sbFilter.toString();
    }

    private boolean isAvailableCell(String netType, int mcc, int mnc, int lacOrTac, int ci) {
        if (mcc == Integer.MAX_VALUE || mnc == Integer.MAX_VALUE) {
            return false;
        }
        if (lacOrTac < 1 || lacOrTac > 65535) {
            return false;
        }
        return !(netType.equals("gsm") ? ci < 1 || ci > 65525 : ci < 1 || ci > 0xFFFFFFF);
    }

    private boolean isAvailableCdmaCell(int sid, int nid, int bid) {
        if (sid > Short.MAX_VALUE) {
            return false;
        }
        if (nid > 65535) {
            return false;
        }
        return bid >= 1 && bid <= 65535;
    }

    private String getNetworktype() {
        String type = "";
        switch (this.telephonyManager.getNetworkType()) {
            case 4: {
                type = "cdma";
                break;
            }
            case 13: {
                type = "lte";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                type = "umts";
                break;
            }
            default: {
                type = "gsm";
            }
        }
        Log.d((String)this.TAG, (String)("network type:" + type));
        return type;
    }

    private void requestLocation(String type, String bs) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("oid", this.assetsProperties.getString("oid", ""));
        map.put("key", this.assetsProperties.getString("key", ""));
        map.put("type", type);
        map.put("bs", bs);
        map.put("hex", "10");
        map.put("to", "2");
        map.put("output", "json");
        AppExecutors.getInstance().getNetworkIO().execute(() -> {
            String response;
            block8: {
                response = "";
                try {
                    response = HttpRequest.post("http://api.gpsspg.com/bs/", map);
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        boolean isLocateSuccess;
                        BSLocation bsLocation = (BSLocation)this.gson.fromJson(response, BSLocation.class);
                        boolean bl = isLocateSuccess = bsLocation.getStatus() == 200;
                        if (this.mXdjaLocationListener != null) {
                            if (isLocateSuccess) {
                                if (bsLocation.getResult().size() > 0) {
                                    this.lastUpdateTimeMills = System.currentTimeMillis();
                                    this.xLocation = this.mTransformer.transform(bsLocation);
                                    this.mXdjaLocationListener.onLocationChanged(this.xLocation);
                                } else {
                                    this.mXdjaLocationListener.onLocationError("\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a" + bsLocation.getMsg());
                                }
                            } else {
                                this.mXdjaLocationListener.onLocationError("\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a" + bsLocation.getMsg());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.mXdjaLocationListener == null) break block8;
                    this.mXdjaLocationListener.onLocationError("\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TimeUtils.getNowString() + ": \n\r");
            sb.append("request:" + bs + "\n\r");
            sb.append("response:" + response + "\n\r");
            FileIOUtils.writeFileFromString((String)(Environment.getExternalStorageDirectory() + "/LbsServiceBak/Location.txt"), (String)sb.toString(), (boolean)true);
        });
    }

    private void requestLocationFromNet(String bs) {
        AppExecutors.getInstance().getNetworkIO().execute(() -> {
            String response;
            block8: {
                response = "";
                try {
                    response = HttpRequest.post(String.format("http://%s:%d/gls/api/bs_location.do", this.serverIP, this.serverPort), bs);
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        BSLocationT bsLocationT = (BSLocationT)this.gson.fromJson(response, BSLocationT.class);
                        String flag = bsLocationT.getFlag();
                        if (this.mXdjaLocationListener != null) {
                            if (TextUtils.equals((CharSequence)"1", (CharSequence)flag)) {
                                BSLocationT.Data data = bsLocationT.getData();
                                if (data != null) {
                                    this.lastUpdateTimeMills = System.currentTimeMillis();
                                    this.xLocation = this.mTransformer.transform(data);
                                    if (this.mXdjaLocationListener != null) {
                                        this.mXdjaLocationListener.onLocationChanged(this.xLocation);
                                    }
                                }
                            } else {
                                this.mXdjaLocationListener.onLocationError("\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a" + bsLocationT.getMessage());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.mXdjaLocationListener == null) break block8;
                    this.mXdjaLocationListener.onLocationError("\u57fa\u7ad9\u5b9a\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TimeUtils.getNowString() + ": \n\r");
            sb.append("request:" + bs + "\n\r");
            sb.append("response:" + response + "\n\r");
            FileIOUtils.writeFileFromString((String)(Environment.getExternalStorageDirectory() + "/LbsServiceBak/Location.txt"), (String)sb.toString(), (boolean)true);
        });
    }

    private void requestFromCellocation(String cl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cl", cl.replace("\\|", ";"));
        AppExecutors.getInstance().getNetworkIO().execute(() -> {
            String response = "";
            try {
                response = HttpRequest.post("http://api.cellocation.com:81/loc/", map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TimeUtils.getNowString() + ": \n\r");
            sb.append("request:" + cl + "\n\r");
            sb.append("response:" + response + "\n\r");
            FileIOUtils.writeFileFromString((String)(Environment.getExternalStorageDirectory() + "/LbsServiceBak/Cellocation.txt"), (String)sb.toString(), (boolean)true);
        });
    }

    private class UpdateLocationExecutor
    implements Runnable {
        private UpdateLocationExecutor() {
        }

        @Override
        public void run() {
            CellProvider.this.getAllCellInfo();
        }
    }
}

