/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.provider;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.IProvider;
import com.xdja.lbs.transform.NativeTransformer;

public class GpsProvider
extends BaseProvider
implements IProvider,
LocationListener {
    private LocationManager locationManager;
    private Criteria criteria;

    public GpsProvider(@NonNull Context context, int priority) {
        super(context, priority);
        this.mTransformer = new NativeTransformer();
        this.timeoutMills = 120000L;
    }

    @Override
    public void initProvide() {
        this.criteria = new Criteria();
        this.criteria.setAccuracy(1);
        this.criteria.setAltitudeRequired(false);
        this.criteria.setBearingRequired(true);
        this.criteria.setCostAllowed(true);
        this.criteria.setSpeedRequired(true);
        this.criteria.setPowerRequirement(0);
        this.criteria.setBearingAccuracy(3);
        this.criteria.setSpeedAccuracy(3);
        this.criteria.setHorizontalAccuracy(3);
        this.criteria.setVerticalAccuracy(3);
        this.criteria.setBearingAccuracy(3);
        this.locationManager = (LocationManager)this.mContext.getSystemService("location");
    }

    @Override
    public boolean startLocation() {
        if (this.openTimeMills == 0L) {
            this.openTimeMills = System.currentTimeMillis();
        }
        if (this.locationManager == null) {
            this.initProvide();
        }
        if (!this.locationManager.isProviderEnabled("gps")) {
            Log.d((String)this.TAG, (String)"GPS disable error");
            if (this.mXdjaLocationListener != null) {
                this.mXdjaLocationListener.onLocationError("\u5f00\u542fGPS\u5b9a\u4f4d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1aGPS\u672a\u5f00\u542f");
            }
            return false;
        }
        String provider = this.locationManager.getBestProvider(this.criteria, true);
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.e((String)this.TAG, (String)"ACCESS_FINE_LOCATION permission not granted error");
            if (this.mXdjaLocationListener != null) {
                this.mXdjaLocationListener.onLocationError("\u5f00\u542fGPS\u5b9a\u4f4d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u6388\u6743\u5b9a\u4f4d\u6743\u9650");
            }
            return false;
        }
        this.locationManager.requestLocationUpdates(provider, 5000L, 0.0f, (LocationListener)this);
        this.isOpen = true;
        Log.d((String)this.TAG, (String)(this.getClass().getSimpleName() + " start"));
        return true;
    }

    @Override
    public void stopLocation() {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates((LocationListener)this);
        }
        super.stopLocation();
    }

    @Override
    public boolean isTimeOut() {
        return this.xLocation == null ? System.currentTimeMillis() - this.openTimeMills > this.timeoutMills : System.currentTimeMillis() - this.lastUpdateTimeMills > this.timeoutMills;
    }

    @Override
    public void onDestroy() {
        this.removeLocationListener();
        this.stopLocation();
        this.criteria = null;
        this.locationManager = null;
    }

    public void onLocationChanged(Location location) {
        if (this.mXdjaLocationListener != null) {
            this.lastUpdateTimeMills = System.currentTimeMillis();
            this.xLocation = this.mTransformer.transform(location);
            this.mXdjaLocationListener.onLocationChanged(this.xLocation);
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
        Log.d((String)this.TAG, (String)("provider enbale:" + provider));
    }

    public void onProviderDisabled(String provider) {
        Log.d((String)this.TAG, (String)("provider disabled:" + provider));
    }
}

