package com.xdja.lbs;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import static com.xdja.lbs.config.Constants.ACTION_CHANGE_INTERVAL;
import static com.xdja.lbs.config.Constants.ACTION_ENABLE_PROVIDE;
import static com.xdja.lbs.config.Constants.ACTION_START_SERVICE;
import static com.xdja.lbs.config.Constants.ACTION_STOP_SERVICE;
import static com.xdja.lbs.config.Constants.EXTRA_AMAP_ENBALE;
import static com.xdja.lbs.config.Constants.EXTRA_BAIDU_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_BS_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_GPS_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_UPLOAD_INTERVAL;

/**
 * @author Guojie
 */
public class LbsManagerBak {
    /**
     * 开启定位服务
     *
     * @param context
     */
    public static void startLbsService(Context context) {
        startLbsService(context, 2, true, true, true, true);
    }

    /**
     * 开启定位服务，并设定定位上传间隔
     *
     * @param context
     * @param interval
     */
    public static void startLbsService(Context context, int interval) {
        startLbsService(context, interval, true, true, true, true);
    }

    /**
     * 开启定位服务，并设置定位上传间隔及开启哪些定位服务
     *
     * @param context
     * @param interval
     * @param gpsEnable   是否开启gp定位
     * @param bsEnable    是否开启基站定位
     * @param aMapEnable  是否开启高德定位
     * @param baiduEnable 是否开启百度定位
     */
    public static void startLbsService(Context context, int interval, boolean gpsEnable, boolean bsEnable, boolean aMapEnable, boolean baiduEnable) {
        Intent intent = new Intent();
        intent.setAction(ACTION_START_SERVICE);
        intent.setPackage(context.getPackageName());
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_UPLOAD_INTERVAL, interval);
        bundle.putBoolean(EXTRA_GPS_ENABLE, gpsEnable);
        bundle.putBoolean(EXTRA_BS_ENABLE, bsEnable);
        bundle.putBoolean(EXTRA_AMAP_ENBALE, aMapEnable);
        bundle.putBoolean(EXTRA_BAIDU_ENABLE, baiduEnable);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    /**
     * 修改定位间隔
     *
     * @param context
     * @param interval 定位间隔，单位s
     */
    public static void changeUploadInterval(Context context, int interval) {
        Intent intent = new Intent();
        intent.setAction(ACTION_CHANGE_INTERVAL);
        intent.setPackage(context.getPackageName());
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA_UPLOAD_INTERVAL, interval);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    /**
     * 修改定位方式
     *
     * @param context
     * @param gpsEnable   是否开启gp定位
     * @param bsEnable    是否开启基站定位
     * @param aMapEnable  是否开启高德定位
     * @param baiduEnable 是否开启百度定位
     */
    public static void enableProvider(Context context, boolean gpsEnable, boolean bsEnable, boolean aMapEnable, boolean baiduEnable) {
        Intent intent = new Intent();
        intent.setAction(ACTION_ENABLE_PROVIDE);
        intent.setPackage(context.getPackageName());
        Bundle bundle = new Bundle();
        bundle.putBoolean(EXTRA_GPS_ENABLE, gpsEnable);
        bundle.putBoolean(EXTRA_BS_ENABLE, bsEnable);
        bundle.putBoolean(EXTRA_AMAP_ENBALE, aMapEnable);
        bundle.putBoolean(EXTRA_BAIDU_ENABLE, baiduEnable);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    /**
     * 停止定位上传服务
     *
     * @param context
     */
    public static void stopLbsService(Context context) {
        Intent intent = new Intent();
        intent.setAction(ACTION_STOP_SERVICE);
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }
}
