package com.xdja.lbs;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.UploadLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.AMapProvider;
import com.xdja.lbs.provider.BaiduProvider;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.CellProvider;
import com.xdja.lbs.provider.GpsProvider;
import com.xdja.lbs.tools.AssetsProperties;
import com.xdja.lbs.tools.PhoneTools;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import static com.xdja.lbs.config.Constants.ACTION_CHANGE_INTERVAL;
import static com.xdja.lbs.config.Constants.ACTION_ENABLE_PROVIDE;
import static com.xdja.lbs.config.Constants.ACTION_LOCATION_CHANGED;
import static com.xdja.lbs.config.Constants.ACTION_START_SERVICE;
import static com.xdja.lbs.config.Constants.ACTION_STOP_SERVICE;
import static com.xdja.lbs.config.Constants.EXTRA_AMAP_ENBALE;
import static com.xdja.lbs.config.Constants.EXTRA_BAIDU_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_BS_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_GPS_ENABLE;
import static com.xdja.lbs.config.Constants.EXTRA_LOCATION;
import static com.xdja.lbs.config.Constants.EXTRA_UPLOAD_INTERVAL;

/**
 * @author Guojie
 */
public class LbsServiceBak extends Service implements XdjaLocationListener {
    private final String TAG = getClass().getSimpleName();
    private ScheduledExecutorService executorService;
    private ScheduledFuture uploadFuture;
    private UploadLocationExecutor locationExecutor;
    private BaseProvider gpsProvider, aMapProvider, bdProvider, bsProvider;
    private XLocation xLocation;
    private boolean isExecutorRunning;
    private Gson gson;
    private AssetsProperties assetsProperties;

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        gson = new GsonBuilder().create();
        assetsProperties = new AssetsProperties(this, "config.properties");
        locationExecutor = new UploadLocationExecutor();
        gpsProvider = new GpsProvider(this, 0);
        aMapProvider = new AMapProvider(this, 1);
        bdProvider = new BaiduProvider(this, 2);
        bsProvider = new CellProvider(this, 3);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        if (intent.getAction() != null) {
            switch (intent.getAction()) {
                case ACTION_START_SERVICE:
                    if (isExecutorRunning) uploadFuture.cancel(true);
                    enableProvider(intent.getExtras());
                    int intervalStart = intent.getIntExtra(EXTRA_UPLOAD_INTERVAL, 2);
                    executorService = LbsExecutors.getInstance().getMultiTaskScheduleExecutorService();
                    uploadFuture = executorService.scheduleAtFixedRate(locationExecutor, 0, intervalStart <= 2 ? 2 : intervalStart, TimeUnit.SECONDS);
                    isExecutorRunning = true;
                    break;
                case ACTION_CHANGE_INTERVAL:
                    int intervalChange = intent.getIntExtra(EXTRA_UPLOAD_INTERVAL, 2);
                    if (isExecutorRunning) {
                        uploadFuture.cancel(true);
                        executorService = LbsExecutors.getInstance().getMultiTaskScheduleExecutorService();
                        uploadFuture = executorService.scheduleAtFixedRate(locationExecutor, 0, intervalChange <= 2 ? 2 : intervalChange, TimeUnit.SECONDS);
                        isExecutorRunning = true;
                    }
                    break;
                case ACTION_ENABLE_PROVIDE:
                    if (isExecutorRunning) {
                        enableProvider(intent.getExtras());
                    }
                    break;
                case ACTION_STOP_SERVICE:
                    stopService();
                    break;
                default:
                    break;
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    /**
     * 开启及关闭定位来源
     *
     * @param bundle
     */
    private void enableProvider(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getBoolean(EXTRA_GPS_ENABLE)) {
                gpsProvider.setLocationListener(this);
                gpsProvider.startLocation();
            } else {
                gpsProvider.removeLocationListener();
                gpsProvider.stopLocation();
            }
            if (bundle.getBoolean(EXTRA_BS_ENABLE)) {
                bsProvider.setLocationListener(this);
                bsProvider.startLocation();
            } else {
                bsProvider.removeLocationListener();
                bsProvider.stopLocation();
            }
            if (bundle.getBoolean(EXTRA_AMAP_ENBALE)) {
                aMapProvider.setLocationListener(this);
                aMapProvider.startLocation();
            } else {
                aMapProvider.removeLocationListener();
                aMapProvider.stopLocation();
            }
            if (bundle.getBoolean(EXTRA_BAIDU_ENABLE)) {
                bdProvider.setLocationListener(this);
                bdProvider.startLocation();
            } else {
                bdProvider.removeLocationListener();
                bdProvider.stopLocation();
            }
        }
    }

    @Override
    public void onLocationChanged(XLocation xLocation) {
        Log.d(TAG, "onLocationChanged,location provider:" + xLocation.getLocationSource());
        this.xLocation = xLocation;
        Intent intent = new Intent();
        intent.setAction(ACTION_LOCATION_CHANGED);
        intent.putExtra(EXTRA_LOCATION, gson.toJson(xLocation));
        sendBroadcast(intent);
    }

    @Override
    public void onLocationError(String errMessage) {
        Log.d(TAG, "onLocationError:" + errMessage);
    }

    private void stopService() {
        gpsProvider.onDestroy();
        bsProvider.onDestroy();
        aMapProvider.onDestroy();
        bdProvider.onDestroy();
        if (isExecutorRunning) {
            uploadFuture.cancel(true);
            uploadFuture = null;
        }
        isExecutorRunning = false;
        stopSelf();
    }

    private class UploadLocationExecutor implements Runnable {

        @SuppressLint("MissingPermission")
        @Override
        public void run() {
            if (xLocation != null) {
                try {
                    UploadLocation uploadLocation = new UploadLocation();
                    uploadLocation.setImei(PhoneTools.getIMEI(LbsServiceBak.this));
                    uploadLocation.setLon(xLocation.getLongitude());
                    uploadLocation.setLat(xLocation.getLatitude());
                    uploadLocation.setCountry(xLocation.getCountry());
                    uploadLocation.setProvince(xLocation.getProvince());
                    uploadLocation.setCity(xLocation.getCity());
                    uploadLocation.setDistrict(xLocation.getDistrict());
                    uploadLocation.setStreet(xLocation.getStreet());
                    uploadLocation.setDescription(xLocation.getAddress());
                    uploadLocation.setSource(xLocation.getLocationSource());
                    uploadLocation.setTime(xLocation.getTime());
                    String message = gson.toJson(uploadLocation);
                    Log.d(TAG, "sendStr:" + message);
                    InetAddress inetAddress = InetAddress.getByName(assetsProperties.getString("uploadHost", ""));
                    byte[] buf = message.getBytes();
                    DatagramSocket datagramSocket = new DatagramSocket();
                    DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length, inetAddress, assetsProperties.getInt("uploadPort", 1080));
                    datagramSocket.send(datagramPacket);
//                    byte[] receBuf = new byte[1024];
//                    DatagramPacket recePacket = new DatagramPacket(receBuf, receBuf.length);
//                    datagramSocket.receive(recePacket);
                    datagramSocket.close();
//                    String receStr = new String(recePacket.getData(), 0, recePacket.getLength());
//                    Log.d(TAG, "receStr:" + receStr);
                } catch (SocketException e) {
                    e.printStackTrace();
                } catch (UnknownHostException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
