package com.xdja.lbs.config;

/**
 * @author Guojie
 */
public class Constants {
    /**
     * 启动定位上传服务
     */
    public static final String ACTION_START_SERVICE = "android.intent.action.lbs.START_SERVICE";
    /**
     * 关闭定位上传服务
     */
    public static final String ACTION_STOP_SERVICE = "android.intent.action.lbs.STOP_SERVICE";
    /**
     * 更改定位来源
     */
    public static final String ACTION_ENABLE_PROVIDE = "android.intent.action.lbs.ENABLE_PROVIDER";
    /**
     * 更改定位间隔
     */
    public static final String ACTION_CHANGE_INTERVAL = "android.intent.action.lbs.CHANGE_INTERVAL";
    /**
     * 定位信息广播action，第三方应用可通过该广播获取定位信息
     */
    public static final String ACTION_LOCATION_CHANGED = "com.xdja.intent.action.location_changed";
    /**
     * intent传值key：是否启用GPS定位
     */
    public static final String EXTRA_GPS_ENABLE = "gps_enable";
    /**
     * intent传值key：是否启用基站定位
     */
    public static final String EXTRA_BS_ENABLE = "bs_enable";
    /**
     * intent传值key：是否启用百度定位
     */
    public static final String EXTRA_BAIDU_ENABLE = "baidu_enable";
    /**
     * intent传值key：是否启用高德定位
     */
    public static final String EXTRA_AMAP_ENBALE = "amap_enable";
    /**
     * intent传值key：更改上传时间间隔
     */
    public static final String EXTRA_UPLOAD_INTERVAL = "upload_interval";
    //以下为预留字段
    public static final String EXTRA_UPLOAD_IP = "upload_ip";
    public static final String EXTRA_UPLOAD_PORT = "upload_port";
    public static final String EXTRA_CELL_IP = "cell_ip";
    public static final String EXTRA_CELL_PORT = "cell_port";
    /**
     * intent传值key：位置信息
     */
    public static final String EXTRA_LOCATION = "location";

    public static class HandlerMessage {
        public static final int MESSAGE_SERVICE_CONNECTION = 1;
        public static final int MESSAGE_LOCATION_UPDATE = 2;
        public static final int MESSAGE_LOCATION_ERROR = 3;
        public static final int MESSAGE_CHANGE_UPLOAD_INTERVAL = 4;
        public static final int MESSAGE_STOP_LOCATION = 5;
    }
}
