package com.xdja.lbs.location;

import android.support.annotation.IntDef;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.xdja.lbs.provider.BaseProvider.AMAP_PROVIDER;
import static com.xdja.lbs.provider.BaseProvider.BAIDU_PROVIDER;
import static com.xdja.lbs.provider.BaseProvider.BS_PROVIDER;
import static com.xdja.lbs.provider.BaseProvider.GPS_PROVIDER;

/**
 * 从GPS、高德、百度、基站转换过的定位信息
 *
 * @author Guojie
 */
public class XLocation implements Serializable {
    /**
     * 定位来源,其值必须是{@link LocationSource}中限定的值
     */
    private int locationSource;
    private String locationSourceDescription;
    /**
     * 定位提供者，例如gps，network，基站，wifi
     */
    private String mProvider;
    /**
     * 定位时间
     */
    private long mTime = 0;
    private String mTimeStr;
    /**
     * 纬度
     */
    private double mLatitude = 0.0;
    /**
     * 经度
     */
    private double mLongitude = 0.0;
    /**
     * 海拔
     */
    private double mAltitude = 0.0f;
    /**
     * 速度
     */
    private float mSpeed = 0.0f;
    /**
     * 国家/地区
     */
    private String mCountry="";
    /**
     * 省份
     */
    private String mProvince="";
    /**
     * 城市
     */
    private String mCity="";
    /**
     * 区县
     */
    private String mDistrict="";
    /**
     * 区号
     */
    private String mAdCode="";
    /**
     * 地址
     */
    private String mAddress="";
    /**
     * 街道
     */
    private String mStreet="";
    /**
     * 街道号
     */
    private String mStreetNum="";
    /**
     * 地址描述
     */
    private String mDescription="";

    public XLocation() {

    }

    public int getLocationSource() {
        return locationSource;
    }

    public void setLocationSource(@LocationSource int locationSource) {
        this.locationSource = locationSource;
    }

    public String getLocationSourceDescription() {
        return locationSourceDescription;
    }

    public void setLocationSourceDescription(String locationSourceDescription) {
        this.locationSourceDescription = locationSourceDescription;
    }

    public String getProvider() {
        return mProvider;
    }

    public void setProvider(String mProvider) {
        this.mProvider = mProvider;
    }

    public long getTime() {
        return mTime;
    }

    public void setTime(long mTime) {
        this.mTime = mTime;
    }
    public String getTimeStr() {
        return mTimeStr;
    }

    public void setTimeStr(String mTimeStr) {
        this.mTimeStr = mTimeStr;
    }
    public double getLatitude() {
        return mLatitude;
    }

    public void setLatitude(double mLatitude) {
        this.mLatitude = mLatitude;
    }

    public double getLongitude() {
        return mLongitude;
    }

    public void setLongitude(double mLongitude) {
        this.mLongitude = mLongitude;
    }

    public double getAltitude() {
        return mAltitude;
    }

    public void setAltitude(double mAltitude) {
        this.mAltitude = mAltitude;
    }

    public float getSpeed() {
        return mSpeed;
    }

    public void setSpeed(float mSpeed) {
        this.mSpeed = mSpeed;
    }

    public String getCountry() {
        return mCountry;
    }

    public void setCountry(String mCountry) {
        this.mCountry = mCountry;
    }

    public String getProvince() {
        return mProvince;
    }

    public void setProvince(String mProvince) {
        this.mProvince = mProvince;
    }

    public String getCity() {
        return mCity;
    }

    public void setCity(String mCity) {
        this.mCity = mCity;
    }

    public String getDistrict() {
        return mDistrict;
    }

    public void setDistrict(String mDistrict) {
        this.mDistrict = mDistrict;
    }

    public String getAdCode() {
        return mAdCode;
    }

    public void setAdCode(String mAdCode) {
        this.mAdCode = mAdCode;
    }

    public String getAddress() {
        return mAddress;
    }

    public void setAddress(String mAddress) {
        this.mAddress = mAddress;
    }

    public String getStreet() {
        return mStreet;
    }

    public void setStreet(String mStreet) {
        this.mStreet = mStreet;
    }

    public String getStreetNum() {
        return mStreetNum;
    }

    public void setStreetNum(String mStreetNum) {
        this.mStreetNum = mStreetNum;
    }

    public String getDescription() {
        return mDescription;
    }

    public void setDescription(String mDescription) {
        this.mDescription = mDescription;
    }

    @Override
    public String toString() {
        return "XLocation{" +
                "locationSource=" + locationSource +
                ", locationSourceDescription='" + locationSourceDescription + '\'' +
                ", mProvider='" + mProvider + '\'' +
                ", mTime=" + mTime +
                ", mTimeStr='" + mTimeStr + '\'' +
                ", mLatitude=" + mLatitude +
                ", mLongitude=" + mLongitude +
                ", mAltitude=" + mAltitude +
                ", mSpeed=" + mSpeed +
                ", mCountry='" + mCountry + '\'' +
                ", mProvince='" + mProvince + '\'' +
                ", mCity='" + mCity + '\'' +
                ", mDistrict='" + mDistrict + '\'' +
                ", mAdCode='" + mAdCode + '\'' +
                ", mAddress='" + mAddress + '\'' +
                ", mStreet='" + mStreet + '\'' +
                ", mStreetNum='" + mStreetNum + '\'' +
                ", mDescription='" + mDescription + '\'' +
                '}';
    }

    @IntDef(flag = false, value = {
            BAIDU_PROVIDER,
            AMAP_PROVIDER,
            GPS_PROVIDER,
            BS_PROVIDER,
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface LocationSource {
    }
}
