package com.xdja.lbs.provider;

import android.content.Context;
import android.util.Log;

import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.transform.ITransformer;

/**
 * @author Guojie
 */
public abstract class BaseProvider implements IProvider {
    protected final String TAG = getClass().getSimpleName();

    /**
     * 百度定位
     */
    public static final int BAIDU_PROVIDER = 1;
    /**
     * 高德定位
     */
    public static final int AMAP_PROVIDER = 2;
    /**
     * 原生GPS定位
     */
    public static final int GPS_PROVIDER = 3;
    /**
     * 基站定位
     */
    public static final int BS_PROVIDER = 4;

    protected Context mContext;
    protected XdjaLocationListener mXdjaLocationListener;
    protected IProvider mProvider;
    protected ITransformer mTransformer;
    protected int priority;
    /**
     * 是否已开启
     */
    protected boolean isOpen;
    protected long lastUpdateTimeMills, openTimeMills, timeoutMills;
    protected XLocation xLocation;

    public BaseProvider(Context context) {
        this(context, 0);
    }

    public BaseProvider(Context context, int priority) {
        this.mContext = context.getApplicationContext();
        this.mProvider = this;
        this.priority = priority;
        isOpen = false;
        mProvider.initProvide();

    }

    public void setLocationListener(XdjaLocationListener xdjaLocationListener) {
        if (xdjaLocationListener != null) {
            this.mXdjaLocationListener = xdjaLocationListener;
        }
    }

    public void removeLocationListener() {
        this.mXdjaLocationListener = null;
    }

    /**
     * 百度定位和高德定位不存在打开定位失败的情况，故重写时只需在需要时调用super方法
     * GPS定位和基站定位存在打开失败的情况，故重写时不能调super方法，需自行维护isOpen和openTimemills
     * 超时判断方法同理
     *
     * @return
     */
    @Override
    public boolean startLocation() {
        isOpen = true;
        openTimeMills = System.currentTimeMillis();
        Log.d(TAG, getClass().getSimpleName() + " start");
        return true;
    }

    @Override
    public void stopLocation() {
        isOpen = false;
        xLocation = null;
        openTimeMills = 0;
        lastUpdateTimeMills = 0;
        Log.d(TAG, getClass().getSimpleName() + " stop");
    }

    public boolean isOpen() {
        return isOpen;
    }

    @Override
    public boolean isTimeOut() {
        if (!isOpen) {
            return false;
        }
        if (xLocation == null) {
            if (System.currentTimeMillis() - openTimeMills > timeoutMills) {
                return true;
            }
        } else {
            if (System.currentTimeMillis() - lastUpdateTimeMills > timeoutMills) {
                return true;
            }
        }
        return false;
    }
    public void setTimeoutMills(long timeoutMills) {
        this.timeoutMills = timeoutMills;
    }
    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}
