package com.xdja.lbs.tools;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author Guojie
 */
public class ThreadPoolManager {
    /**
     * 默认线程名称
     */
    private static final String DEFAULT_THREAD_NAME = "lbs-thread-pool";
    /**
     * 默认队列容量
     */
    private static final int DEFAULT_QUEUE_SIZE = 56;

    /**
     * 创建单个线程线程池
     *
     * @return
     */
    public static ExecutorService newSingleThreadExecutor() {
        return newFixedThreadPool(1);
    }

    /**
     * 创建指定数量线程数线程池
     *
     * @param poolSize 线程数
     * @return
     */
    public static ExecutorService newFixedThreadPool(int poolSize) {
        return newFixedThreadPool(poolSize, DEFAULT_QUEUE_SIZE);
    }

    /**
     * 创建线程池
     *
     * @param poolSize  线程数
     * @param queueSize 队列容量
     * @return
     */
    public static ExecutorService newFixedThreadPool(int poolSize, int queueSize) {
        return newFixedThreadPool(DEFAULT_THREAD_NAME, poolSize, poolSize, queueSize);
    }

    /**
     * 创建线程池
     * * @param threadPoolName  线程池名称
     *
     * @param corePoolSize    核心线程数
     * @param maximumPoolSize 最大线程数
     * @param queueSize       队列容量
     * @return
     */
    public static ExecutorService newFixedThreadPool(String threadPoolName, int corePoolSize, int maximumPoolSize, int queueSize) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(threadPoolName + "-%d").build();
        ExecutorService pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize,
                0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(queueSize), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return pool;
    }

    /**
     * 创建单线程定时线程池
     *
     * @return
     */
    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return newScheduledThreadPool(1);
    }

    /**
     * 创建指定线程数定时任务线程池
     *
     * @param poolSize
     * @return
     */
    public static ScheduledExecutorService newScheduledThreadPool(int poolSize) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(DEFAULT_THREAD_NAME + "-%d").build();
        ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(poolSize, namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return executorService;
    }

}
