package com.xdja.lbs.transform;

import android.os.Environment;
import android.text.TextUtils;

import com.baidu.location.BDLocation;
import com.blankj.utilcode.util.FileIOUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.BaseProvider;

import java.text.ParseException;
import java.text.SimpleDateFormat;


/**
 * 百度定位转换
 *
 * @author Guojie
 */
public class BDTransformer implements ITransformer<BDLocation> {
    private final String TAG = getClass().getSimpleName();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public XLocation transform(BDLocation bdLocation) {
//        Log.d(TAG, "getLongitude:" + bdLocation.getLongitude());
//        Log.d(TAG, "getLatitude:" + bdLocation.getLatitude());
//        Log.d(TAG, "getCountry:" + bdLocation.getCountry());
//        Log.d(TAG, "getCountryCode:" + bdLocation.getCountryCode());
//        Log.d(TAG, "getProvince:" + bdLocation.getProvince());
//        Log.d(TAG, "getCity:" + bdLocation.getCity());
//        Log.d(TAG, "getCityCode:" + bdLocation.getCityCode());
//        Log.d(TAG, "getDistrict:" + bdLocation.getDistrict());
//        Log.d(TAG, "getAdCode:" + bdLocation.getAdCode());
//        Log.d(TAG, "getAddrStr:" + bdLocation.getAddrStr());
//        Log.d(TAG, "getStreet:" + bdLocation.getStreet());
//        Log.d(TAG, "getStreetNumber:" + bdLocation.getStreetNumber());
//        Log.d(TAG, "getLocationDescribe:" + bdLocation.getLocationDescribe());
//        Log.d(TAG, "getTime:" + bdLocation.getTime());
        XLocation xLocation = new XLocation();
        xLocation.setLocationSource(BaseProvider.BAIDU_PROVIDER);
        xLocation.setLocationSourceDescription("百度定位");
        xLocation.setProvider(bdLocation.getLocTypeDescription());
        xLocation.setLongitude(bdLocation.getLongitude());
        xLocation.setLatitude(bdLocation.getLatitude());
        xLocation.setAltitude(bdLocation.getAltitude());
        xLocation.setSpeed(bdLocation.getSpeed());
        xLocation.setCountry(bdLocation.getCountry());
        xLocation.setProvince(bdLocation.getProvince());
        xLocation.setCity(bdLocation.getCity());
        xLocation.setDistrict(bdLocation.getDistrict());
        xLocation.setAdCode(bdLocation.getAdCode());
        xLocation.setStreet(bdLocation.getStreet());
        xLocation.setStreetNum(bdLocation.getStreetNumber());
        StringBuilder address = new StringBuilder();
        address.append(bdLocation.getAddrStr());
        if (!TextUtils.isEmpty(bdLocation.getLocationDescribe())) {
            address.append(bdLocation.getLocationDescribe());
        }
        xLocation.setAddress(address.toString());
        xLocation.setDescription(bdLocation.getLocationDescribe());
        long time = 0;
        try {
            time = simpleDateFormat.parse(bdLocation.getTime()).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        xLocation.setTime(time);
        xLocation.setTimeStr(bdLocation.getTime());
//        FileIOUtils.writeFileFromString(Environment.getExternalStorageDirectory() + "/LbsService/BaiduLocation.txt",
//                TimeUtils.getNowString() + ":" + xLocation.toString() + "\n\r",
//                true);
        return xLocation;
    }
}
