package com.xdja.lbs.transform;

import com.xdja.lbs.location.BSLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.BaseProvider;

import java.text.SimpleDateFormat;

/**
 * 基站定位转换
 *
 * @author Guojie
 */
public class BSTransformer implements ITransformer<BSLocation> {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Override
    public XLocation transform(BSLocation location) {
        XLocation xLocation = new XLocation();
        BSLocation.ResultBean resultBean = location.getResult().get(0);
        xLocation.setLocationSource(BaseProvider.BS_PROVIDER);
        xLocation.setLocationSourceDescription("基站定位");
        xLocation.setLongitude(resultBean.getLng());
        xLocation.setLatitude(resultBean.getLat());
        xLocation.setAddress(resultBean.getAddress() + resultBean.getRoads());
        xLocation.setDescription(resultBean.getRoads());
        xLocation.setTime(System.currentTimeMillis());
        xLocation.setTimeStr(simpleDateFormat.format(System.currentTimeMillis()));
        return xLocation;
    }
}
