package com.xdja.lbs.transform;

import com.xdja.lbs.location.BSLocationT;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.BaseProvider;

import java.text.SimpleDateFormat;

/**
 * 基站定位转换
 */
public class BSTransformerT implements ITransformer<BSLocationT.Data> {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public XLocation transform(BSLocationT.Data location) {
        XLocation xLocation = new XLocation();
        xLocation.setLocationSource(BaseProvider.BS_PROVIDER);
        xLocation.setLocationSourceDescription("基站定位");
        xLocation.setLongitude(location.getLon());
        xLocation.setLatitude(location.getLat());
        xLocation.setCountry(location.getCountry());//国
        xLocation.setProvince(location.getProvince());//省
        xLocation.setCity(location.getCity());//市
        xLocation.setDistrict(location.getDistrict()); //区
        xLocation.setStreet(location.getStreet());//街道
        xLocation.setAddress(location.getAddress());//地址
        xLocation.setDescription(location.getDescription());
        xLocation.setTime(System.currentTimeMillis());
        xLocation.setTimeStr(simpleDateFormat.format(System.currentTimeMillis()));
        return xLocation;
    }
}
