/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.os.Handler;
import android.os.Looper;
import com.xdja.lbs.tools.ThreadPoolManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class LbsExecutors {
    private Executor mainThread;
    private ExecutorService diskIO;
    private ExecutorService networkIO;
    private ScheduledExecutorService singleScheduleExecutorService;
    private ScheduledExecutorService multiTaskScheduleExecutorService;
    protected static LbsExecutors lbsExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LbsExecutors getInstance() {
        if (lbsExecutors != null) return lbsExecutors;
        Class<LbsExecutors> clazz = LbsExecutors.class;
        synchronized (LbsExecutors.class) {
            if (lbsExecutors != null) return lbsExecutors;
            lbsExecutors = new LbsExecutors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return lbsExecutors;
        }
    }

    private LbsExecutors() {
    }

    public ExecutorService getDiskIO() {
        if (this.diskIO == null) {
            this.diskIO = ThreadPoolManager.newSingleThreadExecutor();
        }
        return this.diskIO;
    }

    public ExecutorService getNetworkIO() {
        if (this.networkIO == null) {
            this.networkIO = ThreadPoolManager.newFixedThreadPool(5);
        }
        return this.networkIO;
    }

    public ScheduledExecutorService getSingleScheduleExecutorService() {
        if (this.singleScheduleExecutorService == null) {
            this.singleScheduleExecutorService = ThreadPoolManager.newSingleThreadScheduledExecutor();
        }
        return this.singleScheduleExecutorService;
    }

    public ScheduledExecutorService getMultiTaskScheduleExecutorService() {
        if (this.multiTaskScheduleExecutorService == null) {
            this.multiTaskScheduleExecutorService = ThreadPoolManager.newScheduledThreadPool(5);
        }
        return this.multiTaskScheduleExecutorService;
    }

    public Executor getMainThread() {
        if (this.mainThread == null) {
            this.mainThread = new MainThreadHandler();
        }
        return this.mainThread;
    }

    public void terminated() {
        if (this.networkIO != null && !this.networkIO.isShutdown()) {
            this.networkIO.shutdown();
            this.networkIO = null;
        }
        if (this.singleScheduleExecutorService != null && !this.singleScheduleExecutorService.isShutdown()) {
            this.singleScheduleExecutorService.shutdownNow();
            this.singleScheduleExecutorService = null;
        }
        if (this.multiTaskScheduleExecutorService != null && !this.multiTaskScheduleExecutorService.isShutdown()) {
            this.multiTaskScheduleExecutorService.shutdownNow();
            this.multiTaskScheduleExecutorService = null;
        }
        if (this.diskIO != null && !this.diskIO.isShutdown()) {
            this.diskIO.shutdown();
            this.diskIO = null;
        }
    }

    private static class MainThreadHandler
    implements Executor {
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private MainThreadHandler() {
        }

        @Override
        public void execute(Runnable command) {
            this.mainHandler.post(command);
        }
    }
}

