/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.lbs.LbsExecutors;
import com.xdja.lbs.XdjaLocationClientOption;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.UploadLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.AMapProvider;
import com.xdja.lbs.provider.BaiduProvider;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.CellProvider;
import com.xdja.lbs.provider.GpsProvider;
import com.xdja.lbs.tools.PhoneTools;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class XdjaLbsService
extends Service
implements XdjaLocationListener {
    private final String TAG = this.getClass().getSimpleName();
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture uploadExecutorFuture;
    private ScheduledFuture dispatchExecutorFuture;
    private UploadLocationExecutor locationExecutor;
    private DispatchProviderExecutor dispatchExecutor;
    private BaseProvider gpsProvider;
    private BaseProvider aMapProvider;
    private BaseProvider bdProvider;
    private BaseProvider cellProvider;
    private int interval;
    private XLocation xLocation;
    private boolean isExecutorRunning;
    private boolean isDispatchRunning;
    private Gson gson;
    private LocationManager locationManager;
    private boolean isServing = false;
    private Messenger messenger;
    private Messenger messengerClient;
    private ServerHandler handler;
    private XdjaLocationClientOption option;
    private Map<Integer, BaseProvider> providerMap;

    public void onCreate() {
        Log.d((String)this.TAG, (String)"onCreate");
        super.onCreate();
        if (this.isServing) {
            Log.d((String)this.TAG, (String)"location service can not start again");
        } else {
            this.gson = new GsonBuilder().create();
            this.locationManager = (LocationManager)this.getSystemService("location");
            this.handler = new ServerHandler(Looper.getMainLooper(), this);
            this.messenger = new Messenger((Handler)this.handler);
            this.locationExecutor = new UploadLocationExecutor();
            this.dispatchExecutor = new DispatchProviderExecutor();
            this.gpsProvider = new GpsProvider((Context)this, 0);
            this.cellProvider = new CellProvider((Context)this, 1);
            this.bdProvider = new BaiduProvider((Context)this, 2);
            this.aMapProvider = new AMapProvider((Context)this, 3);
            this.providerMap = new HashMap<Integer, BaseProvider>();
            this.providerMap.put(this.gpsProvider.getPriority(), this.gpsProvider);
            this.providerMap.put(this.cellProvider.getPriority(), this.cellProvider);
            this.providerMap.put(this.bdProvider.getPriority(), this.bdProvider);
            this.providerMap.put(this.aMapProvider.getPriority(), this.aMapProvider);
            this.isServing = true;
        }
    }

    public IBinder onBind(Intent intent) {
        Log.d((String)this.TAG, (String)"onBind");
        return this.messenger.getBinder();
    }

    public void onRebind(Intent intent) {
        Log.d((String)this.TAG, (String)"onRebind");
        super.onRebind(intent);
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)this.TAG, (String)"onUnbind");
        this.stopService();
        return super.onUnbind(intent);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)this.TAG, (String)"onStartCommand");
        if (intent == null || intent.getAction() == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        if (intent.getAction() != null) {
            Bundle bundle = intent.getExtras();
            switch (intent.getAction()) {
                case "android.intent.action.lbs.START_SERVICE": {
                    if (bundle != null) {
                        this.interval = bundle.getInt("upload_interval", 2);
                    }
                    if (this.isExecutorRunning) {
                        this.uploadExecutorFuture.cancel(true);
                    }
                    if (this.isDispatchRunning) {
                        this.dispatchExecutorFuture.cancel(true);
                    }
                    this.enableProvider(this.gpsProvider, true);
                    this.scheduledExecutorService = LbsExecutors.getInstance().getMultiTaskScheduleExecutorService();
                    this.uploadExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.locationExecutor, 0L, this.interval <= 2 ? 2L : (long)this.interval, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    this.dispatchExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.dispatchExecutor, 2L, 2L, TimeUnit.SECONDS);
                    this.isDispatchRunning = true;
                    break;
                }
                case "android.intent.action.lbs.CHANGE_INTERVAL": {
                    int intervalChange = intent.getIntExtra("upload_interval", 2);
                    if (!this.isExecutorRunning) break;
                    this.uploadExecutorFuture.cancel(true);
                    this.uploadExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.locationExecutor, 0L, intervalChange <= 2 ? 2L : (long)intervalChange, TimeUnit.SECONDS);
                    this.isExecutorRunning = true;
                    break;
                }
                case "android.intent.action.lbs.STOP_SERVICE": {
                    this.stopService();
                    break;
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void setOption(XdjaLocationClientOption option) {
        if (option != null) {
            this.option = option;
            CellProvider cellProvider = (CellProvider)this.cellProvider;
            cellProvider.setServerIP(option.getCellLocationIp());
            cellProvider.setServerPort(option.getCellLocationPort());
            this.gpsProvider.setTimeoutMills(option.getGpsTimeout() == 0L ? 120000L : option.getGpsTimeout());
        }
    }

    public void startLocation() {
        this.enableProvider(this.gpsProvider, true);
        if (this.isDispatchRunning) {
            this.dispatchExecutorFuture.cancel(true);
        }
        this.scheduledExecutorService = LbsExecutors.getInstance().getSingleScheduleExecutorService();
        this.dispatchExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.dispatchExecutor, 2L, 2L, TimeUnit.SECONDS);
        this.isDispatchRunning = true;
        if (this.option.isUploadLocation()) {
            this.interval = this.option.getUploadInterval();
            if (this.isExecutorRunning) {
                this.uploadExecutorFuture.cancel(true);
            }
            this.uploadExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.locationExecutor, 0L, this.interval <= 2 ? 2L : (long)this.interval, TimeUnit.SECONDS);
            this.isExecutorRunning = true;
        }
    }

    public void changeUploadInterval() {
        if (this.isExecutorRunning) {
            this.interval = this.option.getUploadInterval();
            this.uploadExecutorFuture.cancel(true);
            this.scheduledExecutorService = LbsExecutors.getInstance().getMultiTaskScheduleExecutorService();
            this.uploadExecutorFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.locationExecutor, 0L, this.interval <= 2 ? 2L : (long)this.interval, TimeUnit.SECONDS);
            this.isExecutorRunning = true;
        }
    }

    private void enableProvider(BaseProvider baseProvider, boolean enable) {
        if (enable) {
            baseProvider.setLocationListener(this);
            boolean ret = baseProvider.startLocation();
            Log.i((String)this.TAG, (String)("enableProvider \u5f00\u542f\u5b9a\u4f4d\u65b9\u5f0f\uff1a" + baseProvider.getClass().getSimpleName() + " \u5f00\u542f\u7ed3\u679c\uff1a" + ret));
        } else {
            baseProvider.stopLocation();
            baseProvider.removeLocationListener();
            Log.i((String)this.TAG, (String)("enableProvider \u5173\u95ed\u5b9a\u4f4d\u65b9\u5f0f\uff1a" + baseProvider.getClass().getSimpleName()));
        }
    }

    @Override
    public void onLocationChanged(XLocation xLocation) {
        Log.d((String)this.TAG, (String)("onLocationChanged,location provider:" + xLocation.getLocationSource()));
        this.xLocation = xLocation;
        Intent intent = new Intent();
        intent.setAction("com.xdja.intent.action.location_changed");
        intent.putExtra("location", this.gson.toJson((Object)xLocation));
        this.sendBroadcast(intent);
        try {
            if (this.handler != null && this.messengerClient != null) {
                Message message = this.handler.obtainMessage(2);
                message.obj = xLocation;
                this.messengerClient.send(message);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onLocationError(String errMessage) {
        Log.d((String)this.TAG, (String)("onLocationError:" + errMessage));
        try {
            Message message = this.handler.obtainMessage(3);
            message.obj = errMessage;
            if (this.messengerClient != null) {
                this.messengerClient.send(message);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void stopService() {
        this.gpsProvider.onDestroy();
        this.cellProvider.onDestroy();
        this.aMapProvider.onDestroy();
        this.bdProvider.onDestroy();
        if (this.isExecutorRunning) {
            this.uploadExecutorFuture.cancel(true);
            this.isExecutorRunning = false;
        }
        if (this.isDispatchRunning) {
            this.dispatchExecutorFuture.cancel(true);
            this.isDispatchRunning = false;
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        LbsExecutors.getInstance().terminated();
        this.dispatchExecutor = null;
        this.locationExecutor = null;
        this.handler = null;
        this.isServing = false;
        this.stopSelf();
    }

    public void onDestroy() {
        Log.d((String)this.TAG, (String)"onDestroy");
        super.onDestroy();
    }

    private void dispatchProvider(BaseProvider checkProvider) {
        BaseProvider nextProvider;
        Log.d((String)this.TAG, (String)("checkProvider=" + checkProvider.getClass().getSimpleName()));
        if (checkProvider.getPriority() > 2) {
            return;
        }
        if (checkProvider.isTimeOut()) {
            nextProvider = this.providerMap.get(checkProvider.getPriority() + 1);
            if (!nextProvider.isOpen()) {
                this.enableProvider(nextProvider, true);
            }
        } else {
            for (Map.Entry<Integer, BaseProvider> entry : this.providerMap.entrySet()) {
                BaseProvider baseProvider = entry.getValue();
                if (baseProvider.getPriority() <= checkProvider.getPriority() || !baseProvider.isOpen()) continue;
                this.enableProvider(baseProvider, false);
            }
            return;
        }
        this.dispatchProvider(nextProvider);
    }

    private static class ServerHandler
    extends Handler {
        private final WeakReference<XdjaLbsService> serviceWeakReference;

        public ServerHandler(Looper looper, XdjaLbsService service) {
            super(looper);
            this.serviceWeakReference = new WeakReference<XdjaLbsService>(service);
        }

        public void handleMessage(Message msg) {
            XdjaLbsService xdjaLbsService = (XdjaLbsService)this.serviceWeakReference.get();
            switch (msg.what) {
                case 1: {
                    if (xdjaLbsService == null) break;
                    xdjaLbsService.setOption((XdjaLocationClientOption)msg.obj);
                    xdjaLbsService.messengerClient = msg.replyTo;
                    xdjaLbsService.startLocation();
                    break;
                }
                case 4: {
                    if (xdjaLbsService == null) break;
                    xdjaLbsService.setOption((XdjaLocationClientOption)msg.obj);
                    xdjaLbsService.changeUploadInterval();
                    break;
                }
            }
        }
    }

    private class DispatchProviderExecutor
    implements Runnable {
        private DispatchProviderExecutor() {
        }

        @Override
        public void run() {
            Log.d((String)XdjaLbsService.this.TAG, (String)("thread name = " + Thread.currentThread().getName()));
            if (!XdjaLbsService.this.gpsProvider.isOpen() && XdjaLbsService.this.locationManager.isProviderEnabled("gps")) {
                XdjaLbsService.this.enableProvider(XdjaLbsService.this.gpsProvider, true);
            }
            XdjaLbsService.this.dispatchProvider(XdjaLbsService.this.gpsProvider);
        }
    }

    private class UploadLocationExecutor
    implements Runnable {
        private UploadLocationExecutor() {
        }

        @Override
        @SuppressLint(value={"MissingPermission"})
        public void run() {
            if (XdjaLbsService.this.xLocation != null) {
                try {
                    UploadLocation uploadLocation = new UploadLocation();
                    uploadLocation.setImei(PhoneTools.getIMEI((Context)XdjaLbsService.this));
                    uploadLocation.setLon(XdjaLbsService.this.xLocation.getLongitude());
                    uploadLocation.setLat(XdjaLbsService.this.xLocation.getLatitude());
                    uploadLocation.setCountry(XdjaLbsService.this.xLocation.getCountry());
                    uploadLocation.setProvince(XdjaLbsService.this.xLocation.getProvince());
                    uploadLocation.setCity(XdjaLbsService.this.xLocation.getCity());
                    uploadLocation.setDistrict(XdjaLbsService.this.xLocation.getDistrict());
                    uploadLocation.setStreet(XdjaLbsService.this.xLocation.getStreet());
                    uploadLocation.setDescription(XdjaLbsService.this.xLocation.getDescription());
                    uploadLocation.setAddress(XdjaLbsService.this.xLocation.getAddress());
                    uploadLocation.setSource(XdjaLbsService.this.xLocation.getLocationSource());
                    uploadLocation.setTime(XdjaLbsService.this.xLocation.getTime());
                    String message = XdjaLbsService.this.gson.toJson((Object)uploadLocation);
                    Log.d((String)XdjaLbsService.this.TAG, (String)("sendStr:" + message));
                    InetAddress inetAddress = InetAddress.getByName(XdjaLbsService.this.option.getUploadIp());
                    byte[] buf = message.getBytes();
                    DatagramSocket datagramSocket = new DatagramSocket();
                    DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length, inetAddress, XdjaLbsService.this.option.getUploadPort());
                    datagramSocket.send(datagramPacket);
                    datagramSocket.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

