/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.xdja.lbs.XdjaLbsService;
import com.xdja.lbs.XdjaLocationClientOption;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.tools.AssetsProperties;
import java.lang.ref.WeakReference;

public class XdjaLocationClient {
    private final String TAG = this.getClass().getSimpleName();
    @NonNull
    private Context context;
    private XdjaLocationClientOption clientOption;
    private XdjaLocationListener xdjaLocationListener;
    private LocationHandler handler;
    private Messenger messengerServer;
    private Messenger messengerClient;
    private boolean isBind;
    private AssetsProperties assetsProperties;
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d((String)XdjaLocationClient.this.TAG, (String)"onServiceConnected");
            XdjaLocationClient.this.messengerServer = new Messenger(iBinder);
            Message message = Message.obtain();
            message.what = 1;
            message.obj = XdjaLocationClient.this.clientOption;
            message.replyTo = XdjaLocationClient.this.messengerClient;
            try {
                XdjaLocationClient.this.messengerServer.send(message);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.d((String)XdjaLocationClient.this.TAG, (String)"onServiceDisconnected");
            XdjaLocationClient.this.isBind = false;
        }
    };

    public XdjaLocationClient(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        this.context = context.getApplicationContext();
        this.assetsProperties = new AssetsProperties(context, "config.properties");
        this.clientOption = new XdjaLocationClientOption();
        this.handler = new LocationHandler(Looper.getMainLooper(), this);
        this.messengerClient = new Messenger((Handler)this.handler);
        this.initClientOption();
        this.context = context;
    }

    public void setLocationOption(XdjaLocationClientOption clientOption) {
        if (clientOption == null) {
            throw new IllegalArgumentException("XdjaLocationClientOption \u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        this.clientOption = clientOption;
    }

    public XdjaLocationClientOption getLocationOption() {
        return this.clientOption;
    }

    private void initClientOption() {
        this.clientOption.setCellLocationIp(this.assetsProperties.getString("cellLocationIP", "127.0.0.1"));
        this.clientOption.setCellLocationPort(this.assetsProperties.getInt("cellLocationPort", 1080));
        this.clientOption.setUploadIp(this.assetsProperties.getString("uploadHost", "127.0.0.1"));
        this.clientOption.setUploadPort(this.assetsProperties.getInt("uploadPort", 1080));
        this.clientOption.setUploadInterval(2);
        this.clientOption.setUploadLocation(false);
    }

    public void changeUploadInterval(int seconds) {
        if (this.clientOption.isUploadLocation()) {
            this.clientOption.setUploadInterval(seconds);
            Message message = Message.obtain();
            message.what = 4;
            message.obj = this.clientOption;
            try {
                if (this.messengerServer != null) {
                    this.messengerServer.send(message);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void startLocation() {
        if (!this.isBind) {
            this.handler = new LocationHandler(Looper.getMainLooper(), this);
            this.messengerClient = new Messenger((Handler)this.handler);
            Intent intent = new Intent(this.context, XdjaLbsService.class);
            this.isBind = this.context.bindService(intent, this.serviceConnection, 1);
            Log.d((String)this.TAG, (String)("isBind=" + this.isBind));
        }
    }

    public void stopLocation() {
        if (this.isBind) {
            try {
                if (this.handler != null) {
                    this.handler.removeCallbacksAndMessages(null);
                    this.handler = null;
                }
                this.context.unbindService(this.serviceConnection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isBind = false;
        }
    }

    public void setLocationListener(XdjaLocationListener locationListener) {
        if (locationListener != null) {
            this.xdjaLocationListener = locationListener;
        }
    }

    public void unRegisterLocationListener() {
        this.xdjaLocationListener = null;
    }

    public void updateLocation(XLocation xLocation) {
        if (this.xdjaLocationListener != null) {
            this.xdjaLocationListener.onLocationChanged(xLocation);
        }
    }

    public void locationError(String message) {
        if (this.xdjaLocationListener != null) {
            this.xdjaLocationListener.onLocationError(message);
        }
    }

    private static class LocationHandler
    extends Handler {
        private final WeakReference<XdjaLocationClient> clientWeakReference;

        public LocationHandler(Looper looper, XdjaLocationClient client) {
            super(looper);
            this.clientWeakReference = new WeakReference<XdjaLocationClient>(client);
        }

        public void handleMessage(Message msg) {
            XdjaLocationClient xdjaLocationClient = (XdjaLocationClient)this.clientWeakReference.get();
            switch (msg.what) {
                case 2: {
                    if (xdjaLocationClient == null) break;
                    xdjaLocationClient.updateLocation((XLocation)msg.obj);
                    break;
                }
                case 3: {
                    if (xdjaLocationClient == null) break;
                    xdjaLocationClient.locationError((String)msg.obj);
                    break;
                }
            }
        }
    }
}

