/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.provider;

import android.content.Context;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationListener;
import com.xdja.lbs.provider.AMapClientManager;
import com.xdja.lbs.provider.BaseProvider;
import com.xdja.lbs.provider.IProvider;
import com.xdja.lbs.transform.AMapTransformer;

public class AMapProvider
extends BaseProvider
implements IProvider,
AMapLocationListener {
    private AMapLocationClient mLocationClient = null;

    public AMapProvider(Context context, int priority) {
        super(context, priority);
        this.mTransformer = new AMapTransformer();
        this.timeoutMills = 20000L;
    }

    @Override
    public void initProvide() {
        this.mLocationClient = AMapClientManager.getInstance(this.mContext).getLocationClient();
    }

    @Override
    public boolean startLocation() {
        if (this.mLocationClient == null) {
            this.initProvide();
        }
        this.mLocationClient.setLocationListener((AMapLocationListener)this);
        this.mLocationClient.startLocation();
        super.startLocation();
        return true;
    }

    @Override
    public void stopLocation() {
        if (this.mLocationClient != null) {
            this.mLocationClient.unRegisterLocationListener((AMapLocationListener)this);
            this.mLocationClient.stopLocation();
        }
        super.stopLocation();
    }

    @Override
    public void onDestroy() {
        this.removeLocationListener();
        if (this.mLocationClient != null) {
            this.stopLocation();
            this.mLocationClient.onDestroy();
        }
    }

    public void onLocationChanged(AMapLocation aMapLocation) {
        boolean isLocateSuccess;
        boolean bl = isLocateSuccess = aMapLocation != null && aMapLocation.getErrorCode() == 0;
        if (this.mXdjaLocationListener != null) {
            if (isLocateSuccess) {
                this.lastUpdateTimeMills = System.currentTimeMillis();
                this.xLocation = this.mTransformer.transform(aMapLocation);
                this.mXdjaLocationListener.onLocationChanged(this.xLocation);
            } else {
                this.mXdjaLocationListener.onLocationError(aMapLocation.getErrorInfo());
            }
        }
    }
}

