/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.provider;

import android.content.Context;
import android.util.Log;
import com.xdja.lbs.callback.XdjaLocationListener;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.provider.IProvider;
import com.xdja.lbs.transform.ITransformer;

public abstract class BaseProvider
implements IProvider {
    protected final String TAG = this.getClass().getSimpleName();
    public static final int BAIDU_PROVIDER = 1;
    public static final int AMAP_PROVIDER = 2;
    public static final int GPS_PROVIDER = 3;
    public static final int BS_PROVIDER = 4;
    protected Context mContext;
    protected XdjaLocationListener mXdjaLocationListener;
    protected IProvider mProvider;
    protected ITransformer mTransformer;
    protected int priority;
    protected boolean isOpen;
    protected long lastUpdateTimeMills;
    protected long openTimeMills;
    protected long timeoutMills;
    protected XLocation xLocation;

    public BaseProvider(Context context) {
        this(context, 0);
    }

    public BaseProvider(Context context, int priority) {
        this.mContext = context.getApplicationContext();
        this.mProvider = this;
        this.priority = priority;
        this.isOpen = false;
        this.mProvider.initProvide();
    }

    public void setLocationListener(XdjaLocationListener xdjaLocationListener) {
        if (xdjaLocationListener != null) {
            this.mXdjaLocationListener = xdjaLocationListener;
        }
    }

    public void removeLocationListener() {
        this.mXdjaLocationListener = null;
    }

    @Override
    public boolean startLocation() {
        this.isOpen = true;
        this.openTimeMills = System.currentTimeMillis();
        Log.d((String)this.TAG, (String)(this.getClass().getSimpleName() + " start"));
        return true;
    }

    @Override
    public void stopLocation() {
        this.isOpen = false;
        this.xLocation = null;
        this.openTimeMills = 0L;
        this.lastUpdateTimeMills = 0L;
        Log.d((String)this.TAG, (String)(this.getClass().getSimpleName() + " stop"));
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isTimeOut() {
        if (!this.isOpen) {
            return false;
        }
        return this.xLocation == null ? System.currentTimeMillis() - this.openTimeMills > this.timeoutMills : System.currentTimeMillis() - this.lastUpdateTimeMills > this.timeoutMills;
    }

    public void setTimeoutMills(long timeoutMills) {
        this.timeoutMills = timeoutMills;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

