/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.tools;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AssetsProperties {
    private final String TAG = this.getClass().getSimpleName();
    private Resources mResources;
    private String mPropertiesFileName = "";
    private Properties mProperties = new Properties();

    public AssetsProperties(Context context, String propertiesFileName) {
        this.mResources = context.getResources();
        this.mPropertiesFileName = propertiesFileName;
        this.openProperties(this.mResources);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.mProperties.getProperty(key));
        }
        catch (Exception e) {
            this.logParseError(key, "int");
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(this.mProperties.getProperty(key));
        }
        catch (Exception e) {
            this.logParseError(key, "float");
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(this.mProperties.getProperty(key));
        }
        catch (Exception e) {
            this.logParseError(key, "double");
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.mProperties.getProperty(key));
        }
        catch (Exception e) {
            this.logParseError(key, "boolean");
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        return this.mProperties.getProperty(key, defaultValue);
    }

    private void openProperties(Resources resources) {
        try {
            InputStream inputStream = resources.getAssets().open(this.mPropertiesFileName);
            this.mProperties.load(inputStream);
        }
        catch (IOException e) {
            Log.wtf((String)this.TAG, (Throwable)e);
        }
    }

    private void logParseError(String key, String target) {
        Log.e((String)this.TAG, (String)("AssetsProperties can't parse property " + key + " as " + target));
    }
}

