/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.tools;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private static final String DEFAULT_THREAD_NAME = "lbs-thread-pool";
    private static final int DEFAULT_QUEUE_SIZE = 56;

    public static ExecutorService newSingleThreadExecutor() {
        return ThreadPoolManager.newFixedThreadPool(1);
    }

    public static ExecutorService newFixedThreadPool(int poolSize) {
        return ThreadPoolManager.newFixedThreadPool(poolSize, 56);
    }

    public static ExecutorService newFixedThreadPool(int poolSize, int queueSize) {
        return ThreadPoolManager.newFixedThreadPool(DEFAULT_THREAD_NAME, poolSize, poolSize, queueSize);
    }

    public static ExecutorService newFixedThreadPool(String threadPoolName, int corePoolSize, int maximumPoolSize, int queueSize) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(threadPoolName + "-%d").build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return pool;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return ThreadPoolManager.newScheduledThreadPool(1);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("lbs-thread-pool-%d").build();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(poolSize, namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return executorService;
    }
}

