/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lbs.transform;

import android.text.TextUtils;
import com.baidu.location.BDLocation;
import com.xdja.lbs.location.XLocation;
import com.xdja.lbs.transform.ITransformer;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class BDTransformer
implements ITransformer<BDLocation> {
    private final String TAG = this.getClass().getSimpleName();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public XLocation transform(BDLocation bdLocation) {
        XLocation xLocation = new XLocation();
        xLocation.setLocationSource(1);
        xLocation.setLocationSourceDescription("\u767e\u5ea6\u5b9a\u4f4d");
        xLocation.setProvider(bdLocation.getLocTypeDescription());
        xLocation.setLongitude(bdLocation.getLongitude());
        xLocation.setLatitude(bdLocation.getLatitude());
        xLocation.setAltitude(bdLocation.getAltitude());
        xLocation.setSpeed(bdLocation.getSpeed());
        xLocation.setCountry(bdLocation.getCountry());
        xLocation.setProvince(bdLocation.getProvince());
        xLocation.setCity(bdLocation.getCity());
        xLocation.setDistrict(bdLocation.getDistrict());
        xLocation.setAdCode(bdLocation.getAdCode());
        xLocation.setStreet(bdLocation.getStreet());
        xLocation.setStreetNum(bdLocation.getStreetNumber());
        StringBuilder address = new StringBuilder();
        address.append(bdLocation.getAddrStr());
        if (!TextUtils.isEmpty((CharSequence)bdLocation.getLocationDescribe())) {
            address.append(bdLocation.getLocationDescribe());
        }
        xLocation.setAddress(address.toString());
        xLocation.setDescription(bdLocation.getLocationDescribe());
        long time = 0L;
        try {
            time = this.simpleDateFormat.parse(bdLocation.getTime()).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        xLocation.setTime(time);
        xLocation.setTimeStr(bdLocation.getTime());
        return xLocation;
    }
}

