package com.xdja.lbs.provider;

import android.content.Context;

import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.xdja.lbs.LbsExecutors;

/**
 * 提供高德地图Client
 * 高德地图提供的方法不会释放线程,重复创建Client对象会造成大量的高德地图线程,最终导致程序溢出
 * 故全局维护一个单例对象
 *
 * @author Guojie
 */
public class AMapClientManager {
    private static AMapClientManager aMapClientManager;
    private AMapLocationClient mLocationClient = null;
    public AMapLocationClientOption mLocationOption = null;
    private Context mContext;

    public static AMapClientManager getInstance(Context context) {
        if (aMapClientManager == null) {
            synchronized (LbsExecutors.class) {
                if (aMapClientManager == null) {
                    aMapClientManager = new AMapClientManager(context);
                }
            }
        }
        return aMapClientManager;
    }

    private AMapClientManager(Context context) {
        this.mContext = context;
    }

    public AMapLocationClient getLocationClient() {
        if (mLocationClient == null) {
            AMapLocationClient.updatePrivacyShow(mContext,true,false);
            AMapLocationClient.updatePrivacyAgree(mContext,true);
            try {
                mLocationClient = new AMapLocationClient(mContext);
                mLocationOption = new AMapLocationClientOption();
                mLocationOption.setInterval(5 * 1000);
                mLocationOption.setNeedAddress(true);
                mLocationOption.setLocationCacheEnable(false);
                mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
                mLocationClient.setLocationOption(mLocationOption);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mLocationClient;
    }
}
