package com.xdja.lbs.provider;


import android.content.Context;

import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.xdja.lbs.transform.AMapTransformer;

/**
 * 提供及管理高德定位
 *
 * @author Guojie
 */
public class AMapProvider extends BaseProvider implements IProvider, AMapLocationListener {
    private AMapLocationClient mLocationClient = null;

    public AMapProvider(Context context, int priority) {
        super(context, priority);
        mTransformer = new AMapTransformer();
        timeoutMills = 20 * 1000;
    }

    @Override
    public void initProvide() {
        mLocationClient = AMapClientManager.getInstance(mContext).getLocationClient();
    }

    @Override
    public boolean startLocation() {
        if (mLocationClient == null) {
            initProvide();
        }
        mLocationClient.setLocationListener(this);
        mLocationClient.startLocation();
        super.startLocation();
        return true;
    }

    @Override
    public void stopLocation() {
        if (mLocationClient != null) {
            mLocationClient.unRegisterLocationListener(this);
            mLocationClient.stopLocation();
        }
        super.stopLocation();
    }

    @Override
    public void onDestroy() {
        removeLocationListener();
        if (mLocationClient != null){
            stopLocation();
            mLocationClient.onDestroy();
        }

    }

    @Override
    public void onLocationChanged(AMapLocation aMapLocation) {
        boolean isLocateSuccess = aMapLocation != null && aMapLocation.getErrorCode() == 0;
        if (mXdjaLocationListener != null) {
            if (isLocateSuccess) {
                lastUpdateTimeMills = System.currentTimeMillis();
                xLocation = mTransformer.transform(aMapLocation);
                mXdjaLocationListener.onLocationChanged(xLocation);
            } else {
                mXdjaLocationListener.onLocationError(aMapLocation.getErrorInfo());
            }
        }
    }
}
