package com.xdja.lbs.tools;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;

/**
 * @author Guojie
 */
public class AssetsProperties {

    private  final String TAG = getClass().getSimpleName();

    private Resources mResources;
    private String mPropertiesFileName = "";
    private java.util.Properties mProperties = new java.util.Properties();

    public AssetsProperties(Context context, String propertiesFileName) {
        mResources = context.getResources();
        mPropertiesFileName = propertiesFileName;
        openProperties(mResources);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(mProperties.getProperty(key));
        } catch (Exception e) {
            logParseError(key, "int");
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(mProperties.getProperty(key));
        } catch (Exception e) {
            logParseError(key, "float");
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(mProperties.getProperty(key));
        } catch (Exception e) {
            logParseError(key, "double");
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(mProperties.getProperty(key));
        } catch (Exception e) {
            logParseError(key, "boolean");
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        return mProperties.getProperty(key, defaultValue);
    }

    private void openProperties(Resources resources) {
        try {
            InputStream inputStream = resources.getAssets().open(mPropertiesFileName);
            mProperties.load(inputStream);
        } catch (IOException e) {
            Log.wtf(TAG, e);
        }
    }

    private void logParseError(String key, String target) {
        Log.e(TAG, "AssetsProperties can't parse property " + key + " as " + target);
    }
}
