/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.config;

import android.os.Environment;
import java.io.File;

public class Config {
    static final String DEFAULT_ROOT_PATH = "safeclient";
    String rootPath = "safeclient";
    public static final Builder DEFAULT = new Builder().setRootPath("safeclient");
    private final String sdcardPath = Environment.getExternalStorageDirectory().getPath() + File.separator;
    private String suffix;
    private String subDirPath;

    private Config(Builder builder) {
        this.rootPath = builder.rootPath;
        this.subDirPath = builder.subDirPath;
        this.suffix = builder.suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRootPath() {
        return this.sdcardPath + this.rootPath;
    }

    public String getAbsSubDirPath() {
        return this.getRootPath() + File.separator + this.subDirPath;
    }

    public String getZipAbsPath() {
        return this.getAbsSubDirPath() + File.separator + "zip" + this.suffix;
    }

    public static class Builder {
        String rootPath;
        String subDirPath;
        String suffix;

        public Builder setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder setSubDirPath(String subDirPath) {
            this.subDirPath = subDirPath;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

