/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.os.Process;
import com.xdja.log.AbsManager;
import com.xdja.log.config.Config;
import com.xdja.log.exception.XdjaLogException;
import com.xdja.log.strategy.DefaultStrategy;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class CrashManager
extends AbsManager
implements Thread.UncaughtExceptionHandler {
    LogFileStrategy strategy;
    Config config;
    final String subDir = "crash";
    final String suffix = ".log";

    public void defineBuilder(Config.Builder builder) {
        this.config = this.buildConfig(builder);
    }

    @Override
    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new DefaultStrategy();
        }
        return this.strategy;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        PrintWriter printWriter = null;
        try {
            LogFileUtils.makeDirectory(this.config.getAbsSubDirPath());
            File file = this.strategy().outputFile(this.config);
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            ex.printStackTrace(printWriter);
        }
        catch (Exception e) {
            throw new XdjaLogException("printWrite throws exception");
        }
        finally {
            printWriter.close();
            Process.killProcess((int)Process.myPid());
        }
    }

    private CrashManager() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.config = this.buildConfig(Config.DEFAULT.setSubDirPath("crash").setSuffix(".log"));
    }

    public static CrashManager getInstance() {
        return CrashManagerHolder.INSTANCE;
    }

    static class CrashManagerHolder {
        static CrashManager INSTANCE = new CrashManager();

        CrashManagerHolder() {
        }
    }
}

