/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.os.Process;
import com.xdja.log.AbsManager;
import com.xdja.log.config.Config;
import com.xdja.log.strategy.DefaultStrategy;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NormalManager
extends AbsManager {
    private static final SimpleDateFormat LOG_DATE_TIME_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss");
    private static ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    LogFileStrategy strategy;
    Config config = this.buildConfig(Config.DEFAULT.setSubDirPath("normal").setSuffix(".log"));
    final String subDir = "normal";
    final String suffix = ".log";

    public void defineBuilder(Config.Builder builder) {
        this.config = this.buildConfig(builder);
    }

    @Override
    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new DefaultStrategy();
        }
        return this.strategy;
    }

    public void writeToFileIfNeeded(final String tag, final String message) {
        sLogExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String logMsg = NormalManager.this.formatLog(tag, message);
                try {
                    LogFileUtils.makeDirectory(NormalManager.this.config.getAbsSubDirPath());
                    File file = NormalManager.this.strategy().outputFile(NormalManager.this.config);
                    LogFileUtils.writeToFile(logMsg, file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private String formatLog(String tag, String msg) {
        return String.format("%spid=%d%s:%s\n", LOG_DATE_TIME_FORMAT.format(new Date()), Process.myPid(), tag, msg);
    }

    public static NormalManager getInstance() {
        return NormalManagerHolder.instance;
    }

    private NormalManager() {
    }

    static class NormalManagerHolder {
        static NormalManager instance = new NormalManager();

        NormalManagerHolder() {
        }
    }
}

