/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.content.Context;
import android.util.Log;
import com.xdja.log.manager.NormalManager;

public class PrintDispatcher {
    static Context mContext;

    public static void init(Context context) {
        mContext = context;
    }

    public static void executeOutput(int level, String tag, String msg) {
        if (PrintDispatcher.isDebuggable()) {
            PrintDispatcher.printToConsole(level, tag, msg);
            NormalManager.getInstance().writeToFileIfNeeded(tag, msg);
        } else if (level >= 3) {
            NormalManager.getInstance().writeToFileIfNeeded(tag, msg);
        } else {
            PrintDispatcher.printToConsole(level, tag, msg);
        }
    }

    static boolean isDebuggable() {
        if (mContext == null) {
            return true;
        }
        return (PrintDispatcher.mContext.getApplicationInfo().flags & 2) != 0;
    }

    private static void printToConsole(int level, String tag, String msg) {
        switch (level) {
            case 1: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)msg);
                break;
            }
            case 2: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case 4: {
                Log.w((String)tag, (String)msg);
                break;
            }
            case 5: {
                Log.e((String)tag, (String)msg);
                break;
            }
        }
    }
}

