/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.util.Log;
import com.xdja.log.AbsManager;
import com.xdja.log.config.Config;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.strategy.ZipFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.IOException;

public class ZipManager
extends AbsManager {
    LogFileStrategy strategy;
    Config config = this.buildConfig(Config.DEFAULT.setSubDirPath("zip").setSuffix(".zip"));
    final String subDir = "zip";
    final String suffix = ".zip";

    public void defineBuilder(Config.Builder builder) {
        this.config = this.buildConfig(builder);
    }

    @Override
    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new ZipFileStrategy();
        }
        return this.strategy;
    }

    public String exportZipLog() throws IOException {
        Log.i((String)"WANGHAO", (String)("ZipManager-->config.getAbsSubDirPath()" + this.config.getAbsSubDirPath()));
        LogFileUtils.makeDirectory(this.config.getAbsSubDirPath());
        return this.strategy().outputFile(this.config).getPath();
    }

    public static ZipManager getInstance() {
        return ZipManagerHolder.instance;
    }

    private ZipManager() {
    }

    static class ZipManagerHolder {
        static ZipManager instance = new ZipManager();

        ZipManagerHolder() {
        }
    }
}

